#!/bin/bash
#
# This script is launching the calibration of mc sequences. 
# 

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=callisto
step=Callisto

set -C

# get sequence # 
numchanged=0
while (( 0 < 21 ))
do 
   if ! [ $numchanged -eq 1 ]
   then 
      if ! [ "$sequence" = "" ] && ! [ "$cereskey" = "" ]
      then
         printprocesslog "INFO $program for sequence $sequence cereskey $cereskey is already running => request new number "
      fi
      gettodo "1" 
      sequence=${primaries[0]}
      cereskey=${primaries[1]}
      if [ "$sequence" = "" ] || [ "$cereskey" = "" ]
      then
         printprocesslog "INFO nothing to do for $program "
      fi
   else
      printprocesslog "INFO starting $program for sequence $sequence cereskey $cereskey"
      break
   fi
   setstatus "start"
done

cd $mars

# run calibration for sequence

# define files and paths
sequfile="$mcsequpath/`printf %08d $sequence | cut -c 1-4`/sequence`printf %08d $sequence`.txt"
outpath=$mcpath/$program/`printf %03d $cereskey`/`printf %08d $sequence | cut -c 1-4`/`printf %08d $sequence | cut -c 5-8`
makedir $outpath
log=$outpath/$program`printf %08d $sequence`
callistorc=$setuppath/$program/`printf %03d $cereskey`/callisto.rc
inpath=$mcpath/ceres/`printf %03d $cereskey`/`printf %08d $sequence | cut -c 1-4`/`printf %08d $sequence | cut -c 5-8`

command="./callisto -b -q -v4 -f --out=$outpath --ind=$inpath --log=$log.log --html=$log.html --config=$callistorc $sequfile"
printprocesslog "INFO executing "$command
$command
check1=$?

case $check1 in
   0)  printprocesslog "INFO $program finished successfully for sequence $sequence cereskey $cereskey (return code $check1)"
       ;;
   *)  printprocesslog "ERROR $program failed for sequence $sequence cereskey $cereskey (return code $check1)"
       check=$check1
       ;;
esac

setstatus "stop"

finish

