#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 $1"

# get dates
if [ "$certaindate" != "" ]
then
   checkstring=`echo $certaindate | grep -E -o '^20[0-9][0-9]\/[01][0-9]\/[0-3][0-9]$'\|'^[0-9][0-9][0-9]$'`
   if [ "$checkstring" = "" ]
   then
      echo "Please give the variable certaindate in the correct format (YYYY/MM/DD)"
      finish
   fi
   getdates $certaindate
else
   if [ "$1" = "" ]
   then 
      # get last 6 nights if hour between 7 and 19h, else only current night
      getdates 3 7 19
   else
      getdates $1
   fi
fi

# for testing only
anapath=/loc_data/analysis

cd $mars

for date in ${dates[@]}
do 
   #echo "processing "$date"..."
   outpath=$anapath/quality/$date
   makedir $outpath 
   logfile=$anapath/quality/$date/quality.log
   year=`echo $date | cut -d/ -f1`
   month=`echo $date | cut -d/ -f2 | sed -e 's/^0//g'`
   day=`echo $date | cut -d/ -f3 | sed -e 's/^0//g'`
   printprocesslog "DEBUG root -q -b fact/plots/quality.C\("$year"\,"$month"\,"$day"\,\""$outpath"\"\) | tee $logfile | intgrep"
   check1=`root -q -b fact/plots/quality.C\($year\,$month\,$day\,\""$outpath"\"\) 2>&1 | tee $logfile | intgrep`
   
   case $check1 in
      0)   printprocesslog "INFO quality.C was successful for date "$date" (check1=$check1)"
           ;;
      *)   printprocesslog "ERROR quality.C failed for date "$date" (check1=$check1)"
           ;;
   esac
done


finish

