#!/bin/bash
#

path=/home_nfs/isdc/fact_opr
oldMars=$path/Mars.von.Thomas.2012.06.19
newMars=$path/Mars.von.Thomas.2012.06.22

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

echo "MARS:"
echo "  old:  "$oldMars
echo "  new:  "$newMars
echo "  set:  "$mars
echo ""
echo "SETUP:"
echo "  out:  "$datapath
echo "  ROOT: "$ROOTSYS
echo ""
echo ""
echo ""
echo " OK? (y/n) "

answer=`head -n 1`
#echo "answer: "$answer

case $answer in
   y) echo "continue checking files"
      echo "=== === === === === === === === === === === === === === === === === === === === === === === === === === === === === ==="
      sleep 1
      echo ""
      echo ""
      ;;
   n) echo "exit"
      exit
      ;;
   *) echo "invalid answer "$answer
      echo "exit"
      exit
      ;;
esac

list=( fact/callisto6.C fact/star.C fact/merpp3.C fact/camtemp.C fact/ctrldev.C \ 
       fact/magictemp.C fact/fillcalib.C fact/calibrate.C fact/curavg.C \
       datacenter/macros/buildseqentriesf.C )


for tool in ${list[@]}
do 
   echo "===> checking "$tool
   diff $oldMars"/"$tool $newMars"/"$tool
   echo ""
   echo ""
   echo ""
done

