#!/bin/bash
#
# Script to copy scheduling plots and suggested schedule to the web 
#

# remarks:
#
# be aware that the script only writes files which don't exist yet
# i.e. in case of a new sw version, old files have to be deleted or moved away
# you can also delete only the txt-files with the suggested schedule
#
# script to be executed on gate, i.e. FACT++ there has to be up-to-date

# create plots for past (-) / future (+) night
directions=( "-" "+" )

# number of days to be treated
numdays=2000

mindate=20111101
maxdate=20191231

plot=/home/fact/FACT++/makeplots
schedule=/users/fact/operation/makeschedule
root=/opt/root_v5.34.10/bin/thisroot.sh

# creating files for $numdays days (if they don't exist yet)
for (( i=0; i < $numdays ; i++))
do 
   for direction in ${directions[@]}
   do
      outpath=/home/factwww/scheduling/`date --date="${direction}${i}days" +%Y/%m/%d`
      date=`date --date="${direction}${i}days" +%Y-%m-%d`
      date2=`date --date="${direction}${i}days" +%Y%m%d`
      schedfile=$outpath"/schedule-"$date2".txt"
      
      if [ $date2 -gt $maxdate ] || [ $date2 -lt $mindate ]
      then
          continue
      fi
      echo -n $date
      if ! [ -d $outpath ]
      then
         mkdir -p $outpath
      else
         if ! [ -e $schedfile ]
         then 
            echo -n " creating "$schedfile"..."
            #echo "$schedule --config /home/fact/makeschedule_gate.rc --date $date >$schedfile 2>/dev/null"
            $schedule --config /home/fact/makeschedule_gate.rc --date $date >$schedfile 2>/dev/null
         else
            echo -n " "$outpath" already done -> continue"
         fi
         echo ""
         continue 
      fi
      echo -n ": creating files..."
      cd $outpath 
      $plot $date --max-zd=75 --max-current=90 >/dev/null 2>&1
      files=`ls *.eps`
      for file in $files
      do 
         if ls $file | grep Legend >/dev/null
         then
            scale=0.8
         else
            scale=1.5
         fi
         pstoimg -quiet -scale $scale $file
      done
      echo -n "creating "$schedfile" ..."
      $schedule --config /home/fact/makeschedule_gate.rc --date $date >$schedfile 2>/dev/null
      echo ""
   done
done
