#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting "$0

logfile=$runlogpath"/FillNumEvts-"$datetime".log"
date >> $logfile

# this script doesn't need variable $doupdate
# filling is done by macro. therefore update is always done

# get dates
if [ "$certaindate" != "" ]
then
   getdates $certaindate
else
   # get all night
   #getdates "all"
   # get last 6 nights if hour between 7 and 19h, else only current night
   getdates 6 7 19
fi


printprocesslog "INFO processing the following night(s): "${dates[@]}
echo  `date`": processing the following night(s): "${dates[@]} >> $logfile 2>&1

cd $mars

# do filling of aux data 
for date in ${dates[@]}
do 
   #echo $date
   runnumber=`echo $date | sed -e 's/\///g'`
   
   # process only data which are available
   if [ $runnumber -lt $firstnight ]
   then
      continue
   fi
   
   # fill run-wise processing
   if [ -d $anapath/ganymed_run/$date ]
   then 
      echo "run numevts.C for night "$runnumber" (run-wise processing) for table "$resulttable1 >> $logfile 2>&1
      printprocesslog "INFO run numevts.C for night "$runnumber" (run-wise processing) for table "$resulttable1
      printprocesslog "DEBUG root -q -b -l fact/processing/numevents.C+\($runnumber\,"\"$anapath"\"\,"\"$resulttable1"\"\,kFALSE\,kFALSE\)"
      check1=`root -q -b -l fact/processing/numevents.C+\($runnumber\,"\"$anapath"\"\,"\"$resulttable1"\"\,kFALSE\,kFALSE\) | tee $logfile | intgrep`
      
      case $check1 in
         1)   printprocesslog "INFO filling numevts.C was successfully for night "$runnumber" and table "$resulttable1" (check1=$check1)"
              ;;
         0)   printprocesslog "WARN connection to DB failed in numevts.C (check1=$check1)"
              ;;
         *)   printprocesslog "ERROR numevts.C failed for night "$runnumber" and table "$resulttable1" (check1=$check1)"
              ;;
      esac
   fi
   
   query="SELECT fSourceKEY FROM RunInfo WHERE fNight="$runnumber" AND fSourceKey > 0 AND fRunTypeKEY=1 GROUP BY fSourceKey "
   sources=( `sendquery` )
   # fill night-wise processing
   for source in ${sources[@]}
   do
      if [ -d $anapath/ganymed_night/$source/$date ]
      then 
         echo "run numevts.C for night "$runnumber" and source "$source" (night-wise processing) " >> $logfile 2>&1
         printprocesslog "INFO run numevents.C for night "$runnumber" and source "$source" (night-wise processing) "
         printprocesslog "DEBUG root -q -b -l fact/processing/numevents.C+\($runnumber\,"\"$anapath"\"\,"\"$resulttable2"\"\,kFALSE\,kTRUE\,$source\)"

         check1=`root -q -b -l fact/processing/numevents.C+\($runnumber\,"\"$anapath"\"\,"\"$resulttable2"\"\,kFALSE\,kTRUE\,$source\) | tee $logfile | intgrep`
         case $check1 in
            1)   printprocesslog "INFO filling numevts.C was successfully for night "$runnumber" and table "$resulttable2" (check1=$check1)"
                 ;;
            0)   printprocesslog "WARN connection to DB failed in numevts.C (check1=$check1)"
                 ;;
            *)   printprocesslog "ERROR numevts.C failed for night "$runnumber" and table "$resulttable2" (check1=$check1)"
                 ;;
         esac
      fi
   done
done

finish


