#!/bin/bash
#
# This script does a backup of the QLA results
# It can be used in different location
# 
# Be careful: do NOT use --delete as on daq callisto files are deleted
# 

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

set -C

# get paths depending on host
case $HOSTNAME in
        dc11) from="fact_opr@isdc-nx00.isdc.unige.ch:/gpfs0/fact/processing/qla/"
              to="/scratch/fact/qla"
              ;;
         daq) from="/loc_data/analysis/"
              to="/newdaq/analysis_bu"
              ## new temporary solution with rsync-servers
              #to="newdaq::newdaq/analysis_bu"
              ;;
   isdc-dl00) from="fact@161.72.93.131:/daq/analysis/"
              #to="/gpfs/scratch/fact/qla"
              to="/gpfs0/fact/processing/qla"
              # for new rsync: update variables
              ;;
           *) echo "no valid host "$HOSTNAME
              exit
              ;;
esac

logfile=$runlogpath"/BackupQLA-"$datetime".log"
date >> $logfile

if ! rsync -av $from $to >> $logfile 2>&1
then
   printprocesslog "CONNECTION problem rsyncing QLA from "$from" to "$to
   echo `date`": problem rsyncing QLA from "$from" to "$to >> $logfile 2>&1
fi


finish >> $logfile 2>&1

