#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=CheckRawFilesAvail
step=RawFileAvailISDC
transferdelay=3 #days
failsdir=/archive/fact/fails/raw

set -C

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

# get todo list
gettodo 


for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s+$s]}
   runid=${primaries[$s+$s+1]}
   currentnight=`date +%Y%m%d`
   checknight=`echo " $currentnight - $transferdelay " | bc -l`
   # work around for 100 missing old files to avoid warnings every hour
   checknight2=`echo " $currentnight - 365 - $transferdelay " | bc -l`
   
   setstatus "start" 

   night2=`echo $night | cut -c 1-4`/`echo $night | cut -c 5-6`/`echo $night | cut -c 7-8`
   rawfile=$rawdata/$night2/$night"_"`printf %03d $runid`".fits.fz"
   failsfile=$failsdir/$night2/$night"_"`printf %03d $runid`".fits.fz"
   
   test -e $rawfile 
   check1=$?

   query="SELECT fHasDrsFile from RunInfo WHERE fNight="$night" AND fRunID="$runid
   numdrs=`sendquery`
   if [ $numdrs -gt 0 ]
   then 
      drsfile=$rawdata/$night2"/"$night"_"`printf %03d $runid`".drs.fits.gz"
      failsdrsfile=$failsdir/$night2"/"$night"_"`printf %03d $runid`".drs.fits.gz"
      test -e $drsfile
      check3=$?
   fi
   
   case $check1 in
      0)   printprocesslog "INFO found rawfile "$rawfile
           if [ $numdrs -gt 0 ]
           then 
              case $check3 in 
                 0) printprocesslog "INFO found drsfile "$drsfile
                    ;;
                 *) test -e $failsdrsfile
                    check4=$?
                    case $check4 in
                       0)   printprocesslog "INFO found rawfile in "$failsdrsfile
                            # drs file is not in archive for files which are ok
                            check=$check4
                            ;;
                       *)   # print warning only for files which are older than $transferdelay days
                            if [ $night -lt $checknight ]
                            then 
                               printprocesslog "WARN "$drsfile" and "$failsdrsfile" missing."
                            else
                               printprocesslog "INFO "$drsfile" and "$failsdrsfile" missing."
                            fi
                            check="no"
                            ;;
                    esac
              esac
           fi
           ;;
      *)   test -e $failsfile
           check2=$?
           
           case $check2 in 
              0)   printprocesslog "INFO found rawfile in "$failsfile
                   # raw file is not in archive for files which are ok
                   check=$check2
                   ;;
              *)   # print warning only for files which are older than $transferdelay days and within the last year
                   if [ $night -lt $checknight ] && [ $night -gt $checknight2 ]
                   then 
                      printprocesslog "WARN "$rawfile" and "$failsfile" missing."
                   else
                      printprocesslog "INFO "$rawfile" and "$failsfile" missing."
                   fi
                   check="no"
                   ;;
           esac
           ;;
   esac

   setstatus "stop" 
done

finish 

