#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# get date 
checkstring=`echo $certaindate | grep -E -o '^20[0-9][0-9]\/[01][0-9]\/[0-3][0-9]$'`
if [ "$checkstring" = "" ] || [ "$certaindate" = "" ]
then
   echo "Please give the variable certaindate in the correct format (YYYY/MM/DD)"
   finish
else
   date=$certaindate
fi

printprocesslog "INFO get list of calibrated files for "$date
calfiles=( `find $anapath/callisto/$date -type f -name '*_C.root' 2>/dev/null | sort` )
if [ ${#calfiles[@]} -eq 0 ]
then
   printprocesslog "INFO no calibrated files available for "$date
   finish
fi
printprocesslog "INFO get list of star files"
starfiles=( `find $anapath/star/$date -type f -name '*_I.root' 2>/dev/null | sort` )
if [ ${#starfiles[@]} -eq 0 ]
then
   printprocesslog "INFO no star files available "
#   finish
fi

echo ${#calfiles[@]}" "${#starfiles[@]}
printprocesslog "INFO #cal-files:"${#calfiles[@]}" #star-files:"${#starfiles[@]}

if [ ${#starfiles[@]} -lt ${#calfiles[@]} ] 
then
   for calfile in ${calfiles[@]}
   do 
      starfile=`echo $calfile | sed -e 's/callisto/star/' -e 's/_C/_I/'`
      logfile=`echo $starfile | sed -e 's/_I.root/-images.log/'`
      if ! ls $starfile >/dev/null 2>&1
      then
         echo $starfile" is missing -> reprocess. "
         outpath=`dirname $starfile`
         makedir $outpath
         `dirname $0`/RunStar.sh $logfile $calfile $outpath $starfile &	
         if ! ls $starfile >/dev/null 2>&1
         then 
            echo "  failed: check log "`echo $starfile | sed -e 's/_I.root/-images.log/'`
            echo "          check calfile "$calfile
         fi
         echo ""
      fi
   done
fi


