#!/bin/bash

sqlpw=/home/$USER/.mysql.pw.op
dbname=factdata

# reference values for corrected R750
rates=(  0.0 # 0
         0.0 # 1
         0.0 # 2
         0.0 # 3
         0.0 # 4
         0.0 # 5
         0.0 # 6
       260.7 # 7
       261.2 # 8
       267.9 # 9
       287.0 #10
       251.3 #11
       251.3 #12
       237.7 #13
       246.6 #14
       243.4 #15
       267.9 #16
       249.4 #17
       254.8 #18
       261.5 #19
       274.2 #20
       264.5 #21
       228.9 #22
       255.1 #23
       269.0 #24
       281.9 #25
       271.4 #26
       270.5 #27
       267.9 #28
         0.0 #29
       246.9 #30
       246.9 #31
       282.8 #32
       282.7 #33
       272.0 #34
       261.1 #35
       256.0 #36
       273.6 #37
       273.2 #38
       280.8 #39
       282.9 #40
       286.7 #41
       290.7 #42
       275.5 #43
       276.1 #44
       267.2 #45
       246.9 #46b
       248.1 #47
       246.2 #48
       253.3 #49
       265.1 #50
       266.2 #51
       264.7 #52
       257.6 #53
       244.9 #54
       244.7 #55
       239.6 #56
       244.6 #57
       242.6 #58
       237.1 #59
       247.3 #60b
       245.5 #61
       260.3 #62
       258.7 #63
       248.7 #64
       248.2 #65
       245.9 #66
       235.9 #67
       233.2 #68
       287.2 #69
       243.1 #70
       231.4 #71
       237.8 #72
       222.3 #73
       214.0 #74
       244.0 #75
       249.6 #76
       253.4 #77
         0.0 #78
       )

for (( i=0; i < ${#rates[@]} ; i++)) 
do
   if [ "${rates[$i]}" = "0.0" ]
   then 
      rate="NULL"
   else
      rate=${rates[$i]}
   fi
   query="UPDATE RunInfo SET fR750Ref="$rate" WHERE fPeriod="$i
   echo $query
   mysql --defaults-file=$sqlpw -u operator -h 10.0.100.21 $dbname -s -e "$query" 
done

# periods 42 and 60 are split: 
# 60a
query="UPDATE RunInfo SET fR750Ref=237.1 WHERE fPeriod=60 AND fNight<20170901"
mysql --defaults-file=$sqlpw -u operator -h 10.0.100.21 $dbname -s -e "$query" 
# 46a
query="UPDATE RunInfo SET fR750Ref=271 WHERE fPeriod=46 AND fNight<20150716"
mysql --defaults-file=$sqlpw -u operator -h 10.0.100.21 $dbname -s -e "$query" 

zd="cos(fZenithDistanceMean/180*Pi())"
min="TIME_TO_SEC(TIMEDIFF(fRunStop,fRunStart))*fEffectiveOn/60"
cor="pow("$zd", 1.091)*exp((1-1/"$zd")*0.593)*exp(1.829*(1-"$zd"))"

# fill corrected R750
query="UPDATE RunInfo SET "
query=$query" fR750Cor=round(fNumThreshold750/("$min")/("$cor"),2) "
query=$query" WHERE fRunTypeKey=1 AND NOT (("$min")/("$cor"))=0"
echo $query
mysql --defaults-file=$sqlpw -u operator -h 10.0.100.21 $dbname -s -e "$query" 

