#!/bin/bash
#
# This script does a backup of the QLA results
# It can be used in different location
# 
# Be careful: do NOT use --delete as on daq callisto files are deleted
# 

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

set -C

logfile=$runlogpath"/BackupQLA-"$datetime".log"
date > $logfile

if [ "$1" = "short" ]
then
   dirs=( "/star" "/callisto" "/ganymed_run" ) 
   printprocesslog "INFO run only short version of rsyncs for the directories "${dirs[@]}
   echo "INFO run only short version of rsyncs for the directories "${dirs[@]}  >> $logfile
fi



# get paths depending on host
case $HOSTNAME in
         daq) from=( "/loc_data/analysis" )
              to=( "/newdaq/analysis_bu" )
              ;;
     newdata) from=( "/data1/analysis" )
              to=( "newdaq:/loc_data/analysis_bu" )
              ;;
   isdc-dl00) from=( "fact@161.72.93.138:/data1/analysis" "/gpfs0/fact/processing/qla" )
              #to="/gpfs/scratch/fact/qla"
              to=( "/gpfs0/fact/processing/qla"  "operator@coma.astro.uni-wuerzburg.de:/fact/data/qla")
              # for new rsync: update variables
              ;;
           *) echo "no valid host "$HOSTNAME
              exit
              ;;
esac



for (( i=0 ; i < ${#from[@]} ; i++ ))
do 
   if [ ${#dirs[@]} -gt 0 ]
   then
      for dir in ${dirs[@]}
      do
         printprocesslog "INFO rsync "${from[$i]}$dir"/ to "${to[$i]}$dir
         echo "rsync from "${from[$i]}$dir"/ to "${to[$i]}$dir >> $logfile 2>&1
         if ! rsync -auv ${from[$i]}$dir"/" ${to[$i]}$dir >> $logfile 2>&1
         then
            printprocesslog "CONNECTION problem rsyncing QLA from "${from[$i]}$dir"/ to "${to[$i]}$dir
            echo `date`": problem rsyncing QLA from "${from[$i]}$dir"/ to "${to[$i]}$dir >> $logfile 2>&1
         fi
      done
   else 
      printprocesslog "INFO rsync "${from[$i]}"/ to "${to[$i]}
      echo "rsync from "${from[$i]}"/ to "${to[$i]} >> $logfile 2>&1
      if ! rsync -auv ${from[$i]}"/" ${to[$i]} >> $logfile 2>&1
      then
         printprocesslog "CONNECTION problem rsyncing QLA from "${from[$i]}"/ to "${to[$i]}
         echo `date`": problem rsyncing QLA from "${from[$i]}"/ to "${to[$i]} >> $logfile 2>&1
      fi
   fi
done

finish >> $logfile 2>&1

