#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=RunStar
step=Star

set -C

# get night and seqid
if [ "$night" = "" ] && [ "$seqid" = "" ]
then 
   # if no number are provided by JobManager
   for (( i=0; i<100; i++ ))
   do 
      # avoid too many simultaneous queries
      sleep $(( ( RANDOM % 10 )  + 1 ))
      # get todo list
      gettodo "1"
      echo ${primaries[@]}

      # get all needed variables
      night=${primaries[0]}
      seqid=${primaries[1]}
      nightpath=`echo $night | cut -c 1-4`"/"`echo $night | cut -c 5-6`"/"`echo $night | cut -c 7-8`
      seqnum=$night"_"`printf %03d $seqid`

      # check if script is already running
      lockfile=$lockpath"/lock-"$program"-"$seqnum".txt"
      checklock continue
      printprocesslog "INFO got todo with try #"$i
      break
   done
else
   nightpath=`echo $night | cut -c 1-4`"/"`echo $night | cut -c 5-6`"/"`echo $night | cut -c 7-8`
   seqnum=$night"_"`printf %03d $seqid`
   # check if script is already running
   lockfile=$lockpath"/lock-"$program"-"$seqnum".txt"
   checklock 
   s=0
   primaries=( $night $seqid )
fi

# get all needed paths and files
seqfile=$seqpath"/"$nightpath"/"$seqnum".seq"
inpath=$datapath"/callisto/"$nightpath
outpath=$datapath"/star/"$nightpath
makedir $outpath
logfile=$outpath"/"$seqnum"-images.log"

cd $mars

# set status in DB
#  maybe already done in JobManager
#  but do it again to have real runtime
setstatus "start" 

# run star 
printprocesslog "INFO starting star.C for sequence "$seqnum

#check1=`root -q -b fact/star.C\("\"$seqfile\""\,7.5\,3.9\,"\"$inpath\""\,"\"$outpath\""\) | tee $logfile | intgrep`
# new cleaning levels starting from version 2012.06.22
#check1=`root -q -b fact/analysis/star.C\("\"$seqfile\""\,4.0\,2.5\,"\"$inpath\""\,"\"$outpath\""\) | tee $logfile | intgrep`
# new cleaning levels for the new calibration
#check1=`root -q -b fact/analysis/star.C\("\"$seqfile\""\,5.2\,3.3\,"\"$inpath\""\,"\"$outpath\""\) | tee $logfile | intgrep`
# new cleaning
check1=`root -q -b fact/analysis/star.C\("\"$seqfile\""\,"\"$inpath\""\,"\"$outpath\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO star was successful for sequence "$seqnum" (check1=$check1)"
        ;;
   *)   printprocesslog "ERROR star.C failed for sequence "$seqnum" (check1=$check1)"
        check=$check1
        ;;
esac

# run merpp
printprocesslog "INFO starting merpp3.C for sequence "$seqnum
logfile=$outpath"/"$seqnum"-merpp.log"

check1=`root -q -b fact/analysis/merpp.C\("\"$seqfile\""\,"\"$outpath\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO merpp was successful for sequence "$seqnum" (check1=$check1)"
        ;;
   *)   printprocesslog "ERROR merpp.C failed for sequence "$seqnum" (check1=$check1)"
        check=10$check1
        ;;
esac

setstatus "stop" 

finish 

