#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=CalcSource
step=CalcSource



# for refilling DB from scratch several processes are useful
# therefore two commandline options have been implemented: 
#   numjobs: number of process that are started from FillEvent.sh
#   numjob: number of the current process [0 to numjobs-1]
if [ "$1" != "" ]
then
   numjobs=$1
   if [ "$2" == "" ]
   then
      echo "missing second argument"
      finish
   else
      numjob=$2
   fi
   if [ $2 -gt $(($1 - 1)) ]
   then
      echo "you cannot start a job with a number larger than the number of jobs you specified"
      finish
   fi
else
   numjobs=1
   numjob=0
fi 


set -C

# check if script is already running
lockfile=$lockpath/lock-$numjob-$program.txt
checklock 

# get todo list
gettodo 

logfile=$runlogpath"/CalcSource-"$numjob"-"$datetime".log"
date >> $logfile

# setup file for calcsource
rc=`ls \`dirname $0\`/../Setup/calcsource.rc`


for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s+$s]}
   runid=${primaries[$s+$s+1]}
   
   if [ $(($runid % $numjobs)) -ne $numjob ]
   then
      printprocesslog "INFO processing only part of the data (runid "$runid", numjobs "$numjobs", "$numjob") -> continue"
      continue
   fi
   
   setstatus "start" 
   if [ $numchanged -eq 0 ]
   then
      printprocesslog "INFO "$numchanged" rows were changed in DB => "$night"_"$runid" is already processed => continue."
      echo "continue"
      continue
   fi

   query="SELECT FileID FROM CalcSourceStatus WHERE fNight="$night" AND fRunID="$runid
   fileid=`sendquery`
   echo "INFO calculating source position for "$fileid
   printprocesslog "INFO calculating source position for "$fileid
   echo "INFO filling star events for "$fileid >> $logfile
   
   # fill star files to DB
   printprocesslog  "INFO /swdev_nfs/FACT++.r19193-bin/calcsource -C $rc $fileid"
   /swdev_nfs/FACT++.r19193-bin/calcsource -C $rc $fileid >> $logfile 2>&1
   check1=$?
   case $check1 in
      0)   printprocesslog "INFO successfully calculated source for "$fileid
           ;;
      *)   printprocesslog "ERROR could not calc source for "$fileid
           check=$check1
           ;;
   esac

   setstatus "stop" 
done

finish 

