#!/bin/bash

sqlpw=/home/$USER/.mysql.pw.op
dbname=factdata
#sqlpw=/home/$USER/.mysql.pw.local
#dbname=factdata20190212

function fill_cu()
{
   query="UPDATE "$1" SET fCU="$2" WHERE fNight between "$3" AND "$4
   mysql --defaults-file=$sqlpw -s -e "$query" 
}

# analysis tables
lc=AnalysisResultsRunCutsLC
isdc=AnalysisResultsRunISDC
qla=AnalysisResultsRunLP


# CU for ISDC analysis
# A [20111115-20120619]: 
#determined w/o DCh (reference values missing)
fill_cu $isdc 23.3 20111115 20120619 
# B [20120620-20130124]: 
fill_cu $isdc 27.0 20120620 20130124 
# C [20130125-20131003]: 
fill_cu $isdc 27.3 20130125 20131003 
# D [20131004-20140520]: 
fill_cu $isdc 32.6 20131004 20140520 
# E [20140520-20150715]: 
fill_cu $isdc 38.4 20140520 20150715 
# F [20150716-20160218]: 
fill_cu $isdc 36.4 20150716 20160218 
# G [20160218-20160831]: 
fill_cu $isdc 29.7 20160218 20160831 
# H [20160901-20170430]: 
fill_cu $isdc 32.2 20160901 20170430 
# I [20170501-20201231]: 
fill_cu $isdc 31.7 20170501 20201231 

# CU for LC-Cuts
# A [20111115-20120619]: 
#determined w/o DCh (reference values missing)
fill_cu $lc 43.1 20111115 20120619 
# B [20120620-20130124]: 
fill_cu $lc 53.8 20120620 20130124 
# C [20130125-20131003]: 
fill_cu $lc 64.6 20130125 20131003 
# D [20131004-20140520]: 
fill_cu $lc 64.7 20131004 20140520 
# E [20140520-20150715]: 
fill_cu $lc 71.4 20140520 20150715 
# F [20150716-20160218]: 
fill_cu $lc 65.4 20150716 20160218 
# G [20160218-20160831]: 
fill_cu $lc 53.0 20160218 20160831 
# H [20160901-20170430]: 
fill_cu $lc 59.7 20160901 20170430 
# I [20170501-20201231]: 
fill_cu $lc 60.7 20170501 20201231 

# CU values for QLA
# see https://www.fact-project.org/logbook/showthread.php?tid=6343&pid=27272#pid27272
# determined w/o zd/th-correction
# A [20111115-20120619]: 
#determined w/o DCh (reference values missing)
fill_cu $qla 18.1 20111115 20120619 
# B [20120620-20130124]: 
fill_cu $qla 19.9 20120620 20130124 
# C [20130125-20131003]: 
fill_cu $qla 20.8 20130125 20131003 
# D [20131004-20140520]: 
fill_cu $qla 17.3 20131004 20140520 
# E [20140520-20150715]: 
fill_cu $qla 23.0 20140520 20150715 
# F [20150716-20160218]: 
fill_cu $qla 21.7 20150716 20160218 
# G [20160218-20160831]: 
fill_cu $qla 16.1 20160218 20160831 
# H [20160901-20170430]: 
fill_cu $qla 33.4 20160901 20170430 
# I [20170501-20201231]: 
fill_cu $qla 15.3 20170501 20201231 

