#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 $1"

# get dates
if [ "$certaindate" != "" ]
then
   checkstring=`echo $certaindate | grep -E -o '^20[0-9][0-9]\/[01][0-9]\/[0-3][0-9]$'\|'^[0-9][0-9][0-9]$'`
   if [ "$checkstring" = "" ]
   then
      echo "Please give the variable certaindate in the correct format (YYYY/MM/DD)"
      finish
   fi
   getdates $certaindate
else
   if [ "$1" = "" ]
   then 
      # get last 6 nights if hour between 7 and 19h, else only current night
      getdates 3 7 19
   else
      getdates $1
   fi
fi

cd $mars

for date in ${dates[@]}
do 
   outpath=$anapath/ratescans/$date
   makedir $outpath
   date2=`echo $date | sed -e 's/\///g'`
   logfile=$outpath/$date2.log
   printprocesslog "INFO root -q -b fact/plots/plotratescan.C\("\"$date2\""\) | tee $logfile | intgrep"
   check1=`root -q -b fact/plots/plotratescan.C\("\"$date2\""\) | tee $logfile | intgrep`
   
   case $check1 in
      0)   printprocesslog "INFO plotratescan.C was successful for date "$date2" (check1=$check1)"
           ;;
      *)   printprocesslog "ERROR plotratescan.C failed for date "$date2" (check1=$check1)"
           ;;
   esac
done


finish

