#!/bin/bash

export LC_ALL="en_US.UTF-8"

ra=$1
dec=$2
name=$3

date=`date +%d-%m-%Y`

echo $date": "$name
echo "RA: "$ra" deg"
echo "Dec: "$dec" deg"

rah=`echo " $ra / 360.0 * 24.0 " | bc -l `
echo "RA: "$rah" h"

rahh=`echo $rah | cut -d. -f1`
#echo "RA: "$rahh

ram=`echo " ( $rah - $rahh )*60 " | bc -l`
ramm=`echo $ram | cut -d. -f1`

ras=`echo " ( $ram - $ramm ) * 60 " | bc -l`
rass=`echo $ras | cut -d. -f1`
rasr=`printf "%0.2f" $ras `

echo "RA: "$rahh":"$ramm":"$rasr

decdd=`echo $dec | cut -d. -f1`
decm=`echo " ( $dec - $decdd )*60 " | bc -l`
decmm=`echo $decm | cut -d. -f1`
decs=`echo " ( $decm - $decmm )*60 " | bc -l`
decsr=`printf "%0.2f" $decs `

echo "Dec: "$decdd":"$decmm":"$decsr

#if [ "$short"=="yes" ]
#then
#   exit
#fi

link="http://tevcat.uchicago.edu/visplot.cgi?tname="$name"&ra="$rahh"%20"$ramm"%20"$rasr"&dec="$decdd"%20"$decmm"%20"$decsr"&lat=28.76&date="$date"&lon=-17.88&mode=1"

firefox -new-window $link

sleep 3

winnum=`xwininfo -tree -root | grep TeVCat | grep -E -o '\ [0-9a-z]{9}\ '`
screenshot=$HOME/Pictures/vis$name-auto.png
import -window $winnum $screenshot
echo "find a screenshot of the visibility at "$screenshot


