#!/bin/bash
#
# Script to print FACT schedule
#
# Remarks: 
#   make sure to use right setup for makeschedule
#   make sure that numdays is large enough to cover 
#     from start to end

# number of days to be treated
numdays=731
#numdays=7

# time range
start=20200101
end=20201231


# for XMM Newton
schedulefile=/home/dorner/FACT.schedule/for.XMM/FACT-Schedule-for-XMM.txt
mrk421file=/home/dorner/FACT.schedule/for.XMM/FACT-Schedule-Mrk421.txt
mrk501file=/home/dorner/FACT.schedule/for.XMM/FACT-Schedule-Mrk501.txt
mrk1959file=/home/dorner/FACT.schedule/for.XMM/FACT-Schedule-1959.txt
# for INTEGRAL proposal
schedulefile=/home/dorner/FACT.schedule/for.INTEGRAL.proposal/FACT-Schedule-for-XMM.txt
mrk421file=/home/dorner/FACT.schedule/for.INTEGRAL.proposal/FACT-Schedule-Mrk421.txt
mrk501file=/home/dorner/FACT.schedule/for.INTEGRAL.proposal/FACT-Schedule-Mrk501.txt
mrk1959file=/home/dorner/FACT.schedule/for.INTEGRAL.proposal/FACT-Schedule-1959.txt

#exit

# filling file
echo "# FACT Schedule from "`date --date="$start" +%Y-%m-%d`" till " `date --date="$end" +%Y-%m-%d` > $schedulefile
echo "# FACT Schedule from "`date --date="$start" +%Y-%m-%d`" till " `date --date="$end" +%Y-%m-%d`

# creating files for $numdays days (if they don't exist yet)
for (( i=0; i < $numdays ; i++))
do 
   date=`date --date="$start+${i}days" +%Y-%m-%d`
   date2=`date --date="$start+${i}days" +%Y%m%d`
   if [ $date2 -gt $end ]
   then
      continue
   fi
   #num=`~/SW/FACT++.2019.01.01/build/makeschedule $date 2>/dev/null | tail -9 | grep ^201 | grep -c SHUTDOWN`
   ~/SW/FACT++.2019.01.01/build/makeschedule $date 2>/dev/null | sed -e '1,/SHUTDOWN/d' | grep ^20[12][0-9] >> $schedulefile
   #echo ""
done

text=`cat $schedulefile`
echo $text | grep -E -o "20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] Mrk 421 \[[0-9]{2,3}'; [0-9]{1,2}.[0-9]\/[0-9]{1,2}.[0-9]\] 20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]" | awk ' { print $1 " " $2 " - " $7 " " $8 " " $5 } ' | sed -e 's/;/]/' > $mrk421file
echo $text | grep -E -o "20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] Mrk 501 \[[0-9]{2,3}'; [0-9]{1,2}.[0-9]\/[0-9]{1,2}.[0-9]\] 20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]" | awk ' { print $1 " " $2 " - " $7 " " $8 " " $5 } ' | sed -e 's/;/]/' > $mrk501file
echo $text | grep -E -o "20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] 1ES 1959\+650 \[[0-9]{2,3}'; [0-9]{1,2}.[0-9]\/[0-9]{1,2}.[0-9]\] 20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]" | awk ' { print $1 " " $2 " - " $7 " " $8 " " $5 } ' | sed -e 's/;/]/' > $mrk1959file

