#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 with option doupdate="$doupdate

query="SELECT Concat(fNight, '_', LPAD(fRunId, 3, 0)) from RunInfo WHERE fFitsFileErrors=0 AND ISNULL(fFileSize)"
runs=( `sendquery` )

printprocesslog ${#runs[@]}" runs to fill."

for run in ${runs[@]}
do
  year=`echo $run | cut -c 1-4`
  month=`echo $run | cut -c 5-6`
  day=`echo $run | cut -c 7-8`
  file=$rawdata"/"$year"/"$month"/"$day"/"$run".fits.fz"
  if ! [ -e $file ]
  then
     printprocesslog "DEBUG "$file" does not exist."
     continue
  fi
  night=`echo $run | cut -d_ -f1`
  runid=`echo $run | cut -d_ -f2`
  size=`stat -c '%s' $file`
  query="UPDATE RunInfo SET fFileSize="$size" WHERE fNight="$night" AND fRunID"=$runid
  printprocesslog "INFO fill size ("$size") for file "$file
  sendquery >/dev/null
done

