#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting "$0

# implement here some check whether QLA / RTA are still running

# find directories to be removed
#  keep last 6 days as RsyncAuxLP.sh copies that many days
dirs=( `find /scratch/aux/ -mindepth 3 -mtime +5 -type d | sort ` )

# delete aux files
for dir in ${dirs[@]}
do 
   printprocesslog "INFO deleting files in "$dir 
   echo `date`": deleting files in "$dir
   
   if ! rm -r $dir
   then
      printprocesslog "ERROR could not delete "$dir
   fi
done

# find all raw files older than 10 hours
files=( `find /scratch/raw/ -mindepth 3 -mmin +600 -type f | sort ` )

# delete raw files
for file in ${files[@]}
do 
   printprocesslog "INFO deleting file "$file 
   echo `date`": deleting file "$file
   
   if ! rm $file
   then
      printprocesslog "ERROR could not delete "$file
   fi
done

dirs=( `find /scratch/raw -type d -empty` )
for dir in ${dirs[@]}
do 
   printprocesslog "INFO deleting directory "$dir 
   rmdir $dir
done

finish
