#!/bin/bash
#
# Script to check whether disk is full
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# possible limits
limits=(  10485760 52428800 104857600 209715200 524288000 1073741824 2147483648 )
texts=(    "10 GB" "50 GB"   "100 GB"  "200 GB"  "500 GB"     "1 TB"     "2 TB" )

# get paths depending on host
case $HOSTNAME in
#        data) dirs=( "/loc_data" "/daq" "/newdaq" )
        data) dirs=( "/loc_data" )
              lowlimits=( 4 ) 
              highlimits=( 5 ) 
              ;;
         daq) dirs=( "/raid10" )
              lowlimits=( 4 ) 
              highlimits=( 5 ) 
              ;;
      newdaq) dirs=( "/fact" )
              lowlimits=( 5 ) 
              highlimits=( 6 ) 
              ;;
     newdata) dirs=( "/scratch" "/data1" "/data2" )
              lowlimits=( 1 4 4 ) 
              highlimits=( 2 5 5 ) 
              lowlimits=( 0 4 4 ) 
              highlimits=( 1 5 5 ) 
              ;;
   isdc-dl00) dirs=( "/gpfs" "/scratch" )
              lowlimits=( 4 ) 
              highlimits=( 4 ) 
              ;;
           *) echo "no valid host "$HOSTNAME
              exit
              ;;
esac

# get current hour
hour=`date +%k`

for (( i=0 ; i< ${#dirs[@]} ; i++ ))
do 
   dir=${dirs[$i]}
   # define disk space limit for check depending on the time
   if [ $hour -lt 8 ] || [ $hour -gt 15 ]
   then
      # during night
      dulimit=${limits[${lowlimits[$i]}]}
      dutext=${texts[${lowlimits[$i]}]}
   else
      # during day
      dulimit=${limits[${highlimits[$i]}]}
      dutext=${texts[${highlimits[$i]}]}
   fi

   # check if directory is mounted (check if empty) 
   printprocesslog "INFO check "$dir" with limit "$dutext"."
   if [ "$(ls -A $dir)" ]
   then 
      # get available disk space
      diskusage=( `df -P $dir | grep $dir ` )
      # check if more than X GB are left on /loc_data
      if [ ${diskusage[3]} -lt $dulimit ] 
      then
         echo "WARN less than "$dutext" left on "$dir" on node "$HOSTNAME" ("${diskusage[3]}")"
         printprocesslog "DISK less than "$dutext" left on "$dir" on node "$HOSTNAME" ("${diskusage[3]}")"
         df -h $dir
         echo ""
      fi
   else
      echo "ERROR "$dir" seems to be not mounted."
      printprocesslog "ERROR "$dir" seems to be not mounted."
   fi
done

finish

