void reflectivity()
{
    TGraph g2;
    g2.SetName("10nm");
    g2.SetTitle("Reflectivity for Al, d = 300nm");
    g2.SetPoint(g2.GetN(), 290, 88.5);
    g2.SetPoint(g2.GetN(), 350, 89.9);
    g2.SetPoint(g2.GetN(), 400, 90.5);
    g2.SetPoint(g2.GetN(), 500, 91.1);
    g2.SetPoint(g2.GetN(), 600, 90.9);
    g2.SetPoint(g2.GetN(), 700, 89.9);
    g2.SetMarkerStyle(kFullDotMedium);
    g2.SetLineWidth(2);
    g2.SetLineStyle(7);
    g2.SetMaximum(95);
    g2.SetMinimum(79);
    TGraph *g=(TGraph*)g2.DrawClone("AC");

    TGraph g1;
    g1.SetName("100nm");
    g1.SetPoint(g1.GetN(), 290, 85.7);
    g1.SetPoint(g1.GetN(), 310, 89.3);
    g1.SetPoint(g1.GetN(), 330, 91.2);
    g1.SetPoint(g1.GetN(), 360, 92.3);
    g1.SetPoint(g1.GetN(), 390, 92.4);
    g1.SetPoint(g1.GetN(), 430, 91.7);
    g1.SetPoint(g1.GetN(), 475, 90.2);
    g1.SetPoint(g1.GetN(), 530, 87.3);
    g1.SetPoint(g1.GetN(), 620, 81.1);
    g1.SetMarkerStyle(kFullDotMedium);
    g1.SetLineWidth(2);
    g1.SetLineColor(kBlue);
    g1.DrawClone("C");

    TH1 *h = g->GetHistogram();

    TAxis *axex = h->GetXaxis();
    TAxis *axey = h->GetYaxis();

    axex->SetTitle("Wavelength \\nu / nm");
    axey->SetTitle("Reflectivity / %");
    axex->CenterTitle();
    axey->CenterTitle();
    axex->SetRangeUser(275, 725);
    axex->SetTitleOffset(1.2);

    gPad->SetGridx();
    gPad->SetGridy();
    gPad->SetBorderMode(0);
    gPad->SetFrameBorderMode(0);
    gPad->SetFillColor(kWhite);
    gPad->SetRightMargin(0.01);
    gPad->SetLeftMargin(0.08);

    TLegend leg(0.55, 0.89, 0.99, 0.99);
    leg.AddEntry("10nm",  "Protection layer  d =  10nm","l");
    leg.AddEntry("100nm", "Protection layer  d = 100nm","l");
    leg.DrawClone();
}

