sensitivity(){
TGraph dwarf;
dwarf.SetName("DWARF");
dwarf.SetTitle("Differential Flux Sensitivity");
TLegend leg(0.75, 0.75, 0.95, 0.95); //x1, y1, x2, y2 in %
//dwarf.SetPoint(dwarf.GetN()+1, x1, y1);
//dwarf.SetPoint(dwarf.GetN()+1, x2, y2);
dwarf.SetPoint(dwarf.GetN(), 0.001, 6E-12);
dwarf.SetPoint(dwarf.GetN(), 0.25, 6E-12);
dwarf.SetPoint(dwarf.GetN(), 0.31, 4.38E-12);
dwarf.SetPoint(dwarf.GetN(), 0.39, 2.1E-12);
dwarf.SetPoint(dwarf.GetN(), 0.45, 1.54E-12);
dwarf.SetPoint(dwarf.GetN(), 0.5, 1.4E-12);
dwarf.SetPoint(dwarf.GetN(), 1, 7.5E-13);
dwarf.SetPoint(dwarf.GetN(), 10, 2.25E-13);
dwarf.SetPoint(dwarf.GetN(), 50, 3.13E-13);
dwarf.SetLineColor(kBlue);
dwarf.SetLineWidth(5);

TGraph *gclone = dwarf.DrawClone("AC"); 

TH1 *h = gclone->GetHistogram(); 

TAxis *axex = h->GetXaxis(); 
TAxis *axey = h->GetYaxis();
//axex->SetLabelOffset(x);
//axey->SetLabelOffset(y);
//axex->SetLabelSize(x);
//axey->SetLabelSize(y);
axex->SetTitleOffset(1.30);
axey->SetTitleOffset(1.2);
//axex->SetTitleSize(x);
//axey->SetTitleSize(y);

axex->SetMoreLogLabels();
//axey->SetMoreLogLabels();

axex->SetTitle("E_0 [TeV]");
axey->SetTitle("F(E<E_0) [cm^{-2}s^{-1}]");

axex->SetRangeUser(0.005, 100);
axey->SetRangeUser(1E-13, 2E-10);
gclone->RemovePoint(0);
leg.AddEntry("DWARF", "DWARF", "l");


TGraph hegras;
hegras.SetName("HEGRAS");
hegras.SetPoint(hegras.GetN(), 0.5, 1.7E-12);
hegras.SetPoint(hegras.GetN(), 1, 1E-12);
hegras.SetPoint(hegras.GetN(), 10, 2.5E-13);
hegras.SetPoint(hegras.GetN(), 50, 2.5E-13);
hegras.SetLineColor(kGreen);
hegras.SetLineWidth(5);
hegras.DrawClone("C");
leg.AddEntry("HEGRAS", "HEGRA CT System", "l");

//TGraph hegra2;
//hegra.SetName("HEGRA2");
//hegra2.SetPoint(hegra2.GetN(), 0.4, 1.7E-12); //1.2E-12
//hegra2.SetLineColor(kBlue);
//hegra2.SetMarkerStyle(kFullDotMedium);
//hegra2.DrawClone("P");
//leg.AddEntry("HEGRA2", "HEGRA CT System 2", "p");

TF1* pow2=new TF1("pow2","1.7e-12/pow(0.4,-0.73)*pow(x,-0.73)",0.4,7);
pow2->SetLineColor(kGreen);
pow2->SetLineStyle(kDashed);
pow2->Draw("same");
leg.AddEntry("pow2", "HEGRA CT System 2", "l");

//TGraph hegra;
//hegra.SetName("HEGRA");
//hegra.SetPoint(hegra.GetN(), 0.75, 7.1E-12); //1E-11
//hegra.SetLineColor(kBlue);
//hegra.SetMarkerStyle(kFullDotMedium);
//hegra.SetMarkerSize(5);
//hegra.DrawClone("P");
//leg.AddEntry("HEGRA", "1 HEGRA CT", "p");

TF1* pow3=new TF1("pow3","7.1e-12/pow(0.75,-0.73)*pow(x,-0.73)",0.75,7);
pow3->SetLineColor(kBlue);
pow3->SetLineStyle(kDashed);
pow3->Draw("same");
leg.AddEntry("pow3", "1 single HEGRA CT", "l");

TGraph whipple; 
whipple.SetName("Whipple");
whipple.SetPoint(whipple.GetN(), 0.25, 1E-11);
whipple.SetPoint(whipple.GetN(), 1, 2.7E-12);
whipple.SetPoint(whipple.GetN(), 3, 1E-12);
whipple.SetPoint(whipple.GetN(), 10, 1E-12);
whipple.SetLineColor(kRed);
whipple.SetLineWidth(5);
whipple.DrawClone("C");
leg.AddEntry("Whipple", "Whipple", "l");
	
//TGraph whipple2;
//whipple2.SetName("Whipple2");
//whipple2.SetPoint(whipple2.GetN(), 0.3, 9.2E-12); //1.3E-11
//whipple2.SetLineColor(kBlue);
//whipple2.SetMarkerStyle(kFullDotMedium);
//whipple2.DrawClone("P");
//leg.AddEntry("Whipple2", "Whipple2", "p");

TF1* pow1=new TF1("pow1","1.3e-11/pow(0.3,-0.95)*pow(x,-0.95)",0.3,3.5);
pow1->SetLineColor(kRed);
pow1->SetLineStyle(kDashed);
pow1->Draw("same");
leg.AddEntry("pow1", "Whipple 2", "l");

TGraph magic_loi; 
magic_loi.SetName("magic_loi");
magic_loi.SetPoint(magic_loi.GetN(), 0.01, 1E-10);
magic_loi.SetPoint(magic_loi.GetN(), 0.045, 1E-11);
magic_loi.SetPoint(magic_loi.GetN(), 0.095, 4.5E-12);
magic_loi.SetPoint(magic_loi.GetN(), 0.55, 1E-12);
magic_loi.SetPoint(magic_loi.GetN(), 1, 6E-13);
magic_loi.SetLineColor(kCyan);
magic_loi.SetLineWidth(5);
magic_loi.SetLineStyle(kDashed);
magic_loi.DrawClone("C");
leg.AddEntry("magic_loi", "MAGIC LoI", "l");

TGraph magic; 
magic.SetName("magic");
magic.SetPoint(magic.GetN(), 0.036, 1.2E-10);
magic.SetPoint(magic.GetN(), 0.045, 8E-11);
magic.SetPoint(magic.GetN(), 0.063, 5E-11);
magic.SetPoint(magic.GetN(), 0.095, 2.3E-11);
magic.SetPoint(magic.GetN(), 0.12, 1.3E-11);
magic.SetPoint(magic.GetN(), 0.15, 7E-12);
magic.SetPoint(magic.GetN(), 0.18, 5E-12);
magic.SetPoint(magic.GetN(), 0.25, 3E-12);
magic.SetPoint(magic.GetN(), 0.31, 2.5E-12);
magic.SetPoint(magic.GetN(), 0.45, 1.1E-12);
magic.SetPoint(magic.GetN(), 0.5, 1.05E-12);
magic.SetPoint(magic.GetN(), 0.6, 9E-13);
magic.SetPoint(magic.GetN(), 0.8, 6E-13);
magic.SetPoint(magic.GetN(), 0.9, 6E-13);
magic.SetPoint(magic.GetN(), 1, 4E-13);
magic.SetLineColor(kCyan);
magic.SetLineWidth(5);
magic.DrawClone("C");
leg.AddEntry("magic", "MAGIC", "l");

leg.DrawClone();
gPad->SetGridx();
gPad->SetGridx();
gPad->SetLogx();
gPad->SetLogy();
gPad->SetFillColor(kWhite);
gPad->SetBottomMargin(0.13);
gPad->SetLeftMargin(0.11);

}