#include "HtmlDelegate.h"

#include <QtGui/QPainter>
#include <QtGui/QTextDocument>

void HtmlDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    QTextDocument doc;
    doc.setHtml(index.data().toString());
    doc.drawContents(painter, option.rect);
}

QSize HtmlDelegate::sizeHint(const QStyleOptionViewItem &/*option*/, const QModelIndex &index) const
{
    QTextDocument doc;
    doc.setHtml(index.data().toString());
    return doc.size().toSize();
}
