#include "MainWindow.h"

#include "dic.hxx"

#include "DockWindow.h"
#include "HtmlDelegate.h"
#include "CheckBoxDelegate.h"

using namespace std;

MainWindow::MainWindow(QWidget *p) : QMainWindow(p)
{
    // setupUi MUST be called before the DimNetwork is initilized
    // In this way it can be ensured that nothing from the
    // DimNetwork arrives before all graphical elements are
    // initialized. This is a simple but very powerfull trick.
    setupUi(this);

    // Now here we can do further setup which should be done
    // before the gui is finally displayed.
    fDimCmdServers->setItemDelegate(new CheckBoxDelegate);
    fDimCmdCommands->setItemDelegate(new CheckBoxDelegate);
    fDimCmdDescription->setItemDelegate(new HtmlDelegate);

    fDimSvcServers->setItemDelegate(new CheckBoxDelegate);
    fDimSvcServices->setItemDelegate(new CheckBoxDelegate);
    fDimSvcDescription->setItemDelegate(new HtmlDelegate);

    fStatusBar->showMessage("FACT++");
}


void MainWindow::on_fTabWidget_tabCloseRequested(int which)
{
    QWidget *w = fTabWidget->widget(which);
    if (!w)
        return;

    QDockWidget *d = w->findChild<QDockWidget*>();
    if (!d)
        return;

    DockWindow *mw = new DockWindow(d, fTabWidget->tabText(which));
    fTabWidget->removeTab(which);
    mw->show();

    if (fTabWidget->count()==1)
        fTabWidget->setTabsClosable(false);
}


void MainWindow::on_fChatSend_clicked(bool)
{
    DimClient::sendCommand("CHAT/MSG", fChatMessage->displayText().toStdString().c_str());
    fChatMessage->clear();
}


void MainWindow::on_fShutdown_clicked(bool)
{
    DimClient::sendCommand("DIS_DNS/KILL_SERVERS", NULL, 0);
}


void MainWindow::on_fShutdownAll_clicked(bool)
{
    DimClient::sendCommand("DIS_DNS/KILL_SERVERS", NULL, 0);
    DimClient::sendCommand("DIS_DNS/EXIT",         1);
}


void MainWindow::on_fStatusFTMEnable_stateChanged(int/* state*/)
{

}
