#ifndef FACT_MainWindow
#define FACT_MainWindow

#include "design.h"

#include <QMainWindow>

class TObject;
class TCanvas;

class MainWindow : public QMainWindow, protected Ui::MainWindow
{
    Q_OBJECT;

    void SelectTab(const QString &name);

protected:
    QPushButton *fFtuLED[40];

public:
    MainWindow(QWidget *p=0);

private slots:
    // System status
    void on_fShutdown_clicked();
    void on_fShutdownAll_clicked();

    // Status LEDs signals
    void on_fStatusFTULed_clicked();
    void on_fStatusFTMLed_clicked();
    void on_fStatusLoggerLed_clicked();
    void on_fStatusChatLed_clicked();
    //void on_fStatusFTMEnable_stateChanged(int state);

    // Tab Widget
    void on_fTabWidget_tabCloseRequested(int which);
    virtual void on_fTabWidget_currentChanged(int) { }

    // Tab: FTM
    void on_fEnablePedestal_clicked(bool) { }
    void on_fEnableLPint_clicked(bool) { }
    void on_fEnableLPext_clicked(bool) { }
    void on_fEnableTrigger_clicked(bool) { }
    void on_fEnableExt1_clicked(bool) { }
    void on_fEnableExt2_clicked(bool) { }
    void on_fEnableTimeMarker_clicked(bool) { }
    void on_fEnableVeto_clicked(bool) { }

    void on_fTriggerSeqPed_valueChanged(int) { }
    void on_fTriggerSeqLPint_valueChanged(int) { }
    void on_fTriggerSeqLPext_valueChanged(int) { }


    void on_fPhysicsCoincidence_valueChanged(int) { }
    void on_fCalibCoincidence_valueChanged(int) { }

    void on_fPhysicsWindow_valueChanged(int) { }
    void on_fCalibWindow_valueChanged(int) { }

    void on_fTriggerInterval_valueChanged(int);
    void on_fTriggerDelay_valueChanged(int);
    void on_fTimeMarkerDelay_valueChanged(int);
    void on_fDeadTime_valueChanged(int);

    void on_fClockCondR0_valueChanged(int) { }
    void on_fClockCondR1_valueChanged(int) { }
    void on_fClockCondR8_valueChanged(int) { }
    void on_fClockCondR9_valueChanged(int) { }
    void on_fClockCondR11_valueChanged(int) { }
    void on_fClockCondR13_valueChanged(int) { }
    void on_fClockCondR14_valueChanged(int) { }
    void on_fClockCondR15_valueChanged(int) { }

    void on_fPrescalingVal_valueChanged(int) { }

    // Tab: FTUs
    void slot_fFtuLED_clicked();
    void on_fPing_toggled(bool);

    // Tab: Rates
    void on_fThresholdVal_valueChanged(int v);
    virtual void on_fThresholdIdx_valueChanged(int) { }

    // Tab: Chat
    void on_fChatSend_clicked();

    // Tab: Commands
    /// Needs access to DimNetwork thus it is implemented in the derived class
    virtual void on_fDimCmdSend_clicked() { }

    // Main menu
    //    void on_fMenuLogSaveAs_triggered(bool)

    virtual void slot_RootEventProcessed(TObject *, unsigned int, TCanvas *) { }
    virtual void slot_RootUpdate() { }
};

#endif
