#include "QCameraWidget.h"
#include <sstream>
#include <iostream>

    QCameraWidget::QCameraWidget(QWidget *pparent) : BasicGlCamera(pparent)
    {
        fWhite = -1;
        fWhitePatch = -1;
        fBold.resize(1440);
        fEnable.resize(1440);
        fBold.assign(1440, false);
        fEnable.assign(1440, true);
        fMin = -1;
        fMax = -1;
        lastFace = -1;
        unitsText = "";
        titleText = "This is a title";
        dataText = "";
        logScale = false;
        cameraRotation = 0;

        pixelContourColour[0] = 0.1f;
        pixelContourColour[1] = 0.1f;
        pixelContourColour[2] = 0.1f;
        patchesCoulour[0] = 0.15f;
        patchesCoulour[1] = 0.15f;
        patchesCoulour[2] = 0.15f;
        highlightedPatchesCoulour[0] = 0.6f;
        highlightedPatchesCoulour[1] = 0.6f;
        highlightedPatchesCoulour[2] = 0.6f;
        highlightedPixelsCoulour[0] = 0.8f;
        highlightedPixelsCoulour[1] = 0.8f;
        highlightedPixelsCoulour[2] = 0.8f;

        regularPalettePlease(true);

        CalculatePixelsColor();

        setFont(QFont("Arial", 8));
        int buttonShift=0;
        scaleLabel = new QLabel("Scale", this);
//        buttonShift += scaleLabel->height();

        linearButton = new QRadioButton("Linear", this);
        linearButton->move(scaleLabel->width(), buttonShift);
        buttonShift += linearButton->height();

        logButton = new QRadioButton("Log", this);
        logButton->move(scaleLabel->width(), buttonShift);
        buttonShift += logButton->height()*1.1f;

        colorPaletteLabel = new QLabel("Colour\nPalette", this);
        colorPaletteLabel->move(0, buttonShift);
 //       buttonShift += colorPaletteLabel->height();

        regularPaletteButton = new QRadioButton("Regular", this);
        regularPaletteButton->move(colorPaletteLabel->width(), buttonShift);
        buttonShift += regularPaletteButton->height();

        prettyPaletteButton = new QRadioButton("Pretty", this);
        prettyPaletteButton->move(colorPaletteLabel->width(), buttonShift);
        buttonShift += prettyPaletteButton->height();

        greyScalePaletteButton = new QRadioButton("Grey Scale", this);
        greyScalePaletteButton->move(colorPaletteLabel->width(), buttonShift);
        buttonShift += greyScalePaletteButton->height();

        glowingPaletteButton = new QRadioButton("Glowing", this);
        glowingPaletteButton->move(colorPaletteLabel->width(), buttonShift);
        buttonShift += glowingPaletteButton->height()*1.1f;

        rotationLabel = new QLabel("Camera\nRotation", this);
        rotationLabel->move(0, buttonShift);
 //       buttonShift += rotationLabel->height();

        unsigned short utf16Array;
        utf16Array = 0x00b0;
        QString degreeSymbol(QString::fromUtf16(&utf16Array, 1));
        QString zerostr("0" + degreeSymbol);
        zeroRotationButton = new QRadioButton(zerostr, this);
        zeroRotationButton->move(rotationLabel->width(), buttonShift);
        buttonShift += zeroRotationButton->height();
         QString minus90str("-90" + degreeSymbol);
        minus90RotationButton = new QRadioButton(minus90str, this);
        minus90RotationButton->move(rotationLabel->width(), buttonShift);
        buttonShift += minus90RotationButton->height();
        QString plus90str("+90"+degreeSymbol);
        plus90Rotationbutton = new QRadioButton(plus90str, this);
        plus90Rotationbutton->move(rotationLabel->width(), buttonShift);


        scaleGroup = new QButtonGroup(pparent);
        colorGroup = new QButtonGroup(pparent);
        rotationGroup = new QButtonGroup(pparent);
        scaleGroup->addButton(linearButton);
        scaleGroup->addButton(logButton);
        colorGroup->addButton(regularPaletteButton);
        colorGroup->addButton(prettyPaletteButton);
        colorGroup->addButton(greyScalePaletteButton);
        colorGroup->addButton(glowingPaletteButton);
        rotationGroup->addButton(zeroRotationButton);
        rotationGroup->addButton(minus90RotationButton);
        rotationGroup->addButton(plus90Rotationbutton);

        linearButton->setChecked(true);
        regularPaletteButton->setChecked(true);
        zeroRotationButton->setChecked(true);

//        linearButton->palette.setColor();

        linearButton->setAutoFillBackground(true);
        logButton->setAutoFillBackground(true);
        regularPaletteButton->setAutoFillBackground(true);
        prettyPaletteButton->setAutoFillBackground(true);
        greyScalePaletteButton->setAutoFillBackground(true);
        glowingPaletteButton->setAutoFillBackground(true);
        zeroRotationButton->setAutoFillBackground(true);
        minus90RotationButton->setAutoFillBackground(true);
        plus90Rotationbutton->setAutoFillBackground(true);
        scaleLabel->setAutoFillBackground(true);
        colorPaletteLabel->setAutoFillBackground(true);
        rotationLabel->setAutoFillBackground(true);

        linearButton->hide();
        logButton->hide();
        regularPaletteButton->hide();
        prettyPaletteButton->hide();
        greyScalePaletteButton->hide();
        glowingPaletteButton->hide();
        zeroRotationButton->hide();
        minus90RotationButton->hide();
        plus90Rotationbutton->hide();
        scaleLabel->hide();
        colorPaletteLabel->hide();
        rotationLabel->hide();

        connect(linearButton, SIGNAL(toggled(bool)),
                 this, SLOT(linearScalePlease(bool)));
        connect(logButton, SIGNAL(toggled(bool)),
                 this, SLOT(logScalePlease(bool)));
        connect(regularPaletteButton, SIGNAL(toggled(bool)),
                 this, SLOT(regularPalettePlease(bool)));
        connect(prettyPaletteButton, SIGNAL(toggled(bool)),
                 this, SLOT(prettyPalettePlease(bool)));
        connect(greyScalePaletteButton, SIGNAL(toggled(bool)),
                 this, SLOT(greyScalePalettePlease(bool)));
        connect(glowingPaletteButton, SIGNAL(toggled(bool)),
                 this, SLOT(glowingPalettePlease(bool)));
        connect(zeroRotationButton, SIGNAL(toggled(bool)),
                 this, SLOT(zeroRotationPlease(bool)));
        connect(minus90RotationButton, SIGNAL(toggled(bool)),
                 this, SLOT(plus90RotationPlease(bool)));
        connect(plus90Rotationbutton, SIGNAL(toggled(bool)),
                 this, SLOT(minus90RotationPlease(bool)));



   }

    void QCameraWidget::paintGL()
    {
        glClear(GL_COLOR_BUFFER_BIT);
         glLoadIdentity();

         glTranslatef(0,-0.44,0);
         glRotatef(cameraRotation, 0,0,-1);
         if (cameraRotation == 90)
         {
             glTranslatef(-0.45,-0.45,0);
  //           cout << "correction" << endl;
         }
         if (cameraRotation == -90)
         {
             glTranslatef(0.45,-0.45,0);
         }
         glScalef(1.5, 1.5, 1.5);
         drawCamera(true);

         glLineWidth(1.0f);
         glColor3fv(highlightedPixelsCoulour);
         for (vector<int>::iterator it = highlightedPixels.begin(); it!= highlightedPixels.end(); it++)
         {
             drawHexagon(*it, false);
         }
         drawPatches();

        glLineWidth(1.0f);

        //glColor3f(1.f - pixelsColor[fWhite][0],1.f - pixelsColor[fWhite][1],1.f - pixelsColor[fWhite][2]);
        if (fWhite != -1)
        {
            glColor3f(1.f, 0.f, 0.f);
            drawHexagon(fWhite, false);
        }
        DrawCameraText();

        DrawScale();

//        if (linearButton->isVisible())
//            repaintInterface();
    }
    void QCameraWidget::drawCamera(bool alsoWire)
    {
        if (!pixelColorUpToDate)
            CalculatePixelsColor();
        glLineWidth(1.0);
        for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
        {
            glColor3fv(pixelsColor[i]);
            glLoadName(i);
            drawHexagon(i,true);
        }
        if (!alsoWire)
            return;
        glColor3fv(pixelContourColour);//0.0f,0.0f,0.0f);
        for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
        {
            drawHexagon(i, false);
        }
    }
    void QCameraWidget::drawPatches()
    {
        glLineWidth(2.0f);
        glColor3fv(patchesCoulour);
         glBegin(GL_LINES);
                 for (int i=0;i<NTMARK;i++)
                {
                     for (unsigned int j=0;j<patchesIndices[i].size();j++)
                     {
                         glVertex2fv(verticesList[patchesIndices[i][j].first]);
                         glVertex2fv(verticesList[patchesIndices[i][j].second]);
                     }
                 }
         glEnd();

         glColor3fv(highlightedPatchesCoulour);
         glBegin(GL_LINES);
         for (vector<int>::iterator it=highlightedPatches.begin(); it!= highlightedPatches.end(); it++)
         {
             for (unsigned int j=0;j<patchesIndices[*it].size();j++)
             {
                 glVertex2fv(verticesList[patchesIndices[*it][j].first]);
                 glVertex2fv(verticesList[patchesIndices[*it][j].second]);
             }
         }
         glEnd();
         if (fWhitePatch != -1)
         {
             glColor3f(1.f, 0.5f, 0.f);//patchColour);//[0],patchColour[1],patchColour[2]);//0.5f, 0.5f, 0.3f);
             glBegin(GL_LINES);
             for (unsigned int j=0;j<patchesIndices[fWhitePatch].size();j++)
             {
                 glVertex2fv(verticesList[patchesIndices[fWhitePatch][j].first]);
                 glVertex2fv(verticesList[patchesIndices[fWhitePatch][j].second]);
             }
             glEnd();
         }

    }
    void QCameraWidget::Reset()
    {
        fBold.assign(1440, false);
    }
    void QCameraWidget::toggleInterfaceDisplay()
    {
        if (linearButton->isVisible())
        {
            linearButton->hide();
            logButton->hide();
            regularPaletteButton->hide();
            prettyPaletteButton->hide();
            greyScalePaletteButton->hide();
            glowingPaletteButton->hide();
            zeroRotationButton->hide();
            minus90RotationButton->hide();
            plus90Rotationbutton->hide();
            scaleLabel->hide();
            colorPaletteLabel->hide();
            rotationLabel->hide();
        }
        else
        {
            linearButton->show();
            logButton->show();
            regularPaletteButton->show();
            prettyPaletteButton->show();
            greyScalePaletteButton->show();
            glowingPaletteButton->show();
            zeroRotationButton->show();
            minus90RotationButton->show();
            plus90Rotationbutton->show();
            scaleLabel->show();
            colorPaletteLabel->show();
            rotationLabel->show();
        }
    }
    void QCameraWidget::repaintInterface()
    {
        return;
        setFont(QFont("Arial", 10));
 //       glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
        linearButton->render(this);
        logButton->render(this);
        regularPaletteButton->render(this);
        prettyPaletteButton->render(this);
        greyScalePaletteButton->render(this);
        glowingPaletteButton->render(this);
        zeroRotationButton->render(this);
        minus90RotationButton->render(this);
        plus90Rotationbutton->render(this);
 //       scaleLabel->repaint();
        colorPaletteLabel->render(this);
        rotationLabel->render(this);

        scaleLabel->render(this);
  //       cout << scaleLabel->autoFillBackground() << endl;
    }
    void QCameraWidget::mousePressEvent(QMouseEvent *cEvent)
    {
        if (cEvent->pos().x() > width()-(width()/50.f))
        {
            toggleInterfaceDisplay();
            return;
        }
        int face = PixelAtPosition(cEvent->pos());
        if (face != -1) {
            fWhite = face;
            fWhitePatch = pixelsPatch[fWhite];
 //           CalculatePatchColor();
            emit signalCurrentPixel(face);
            }
        else
        {
            fWhite = -1;
            fWhitePatch = -1;
        }
        updateGL();
   }
    void QCameraWidget::mouseMoveEvent(QMouseEvent* cEvent)
    {
        int face = PixelAtPosition(cEvent->pos());
        if (face != -1 && lastFace != face) {
            emit signalPixelMoveOver(face);
        }
        lastFace = face;
    }
    void QCameraWidget::mouseDoubleClickEvent(QMouseEvent* cEvent)
    {
        int face = PixelAtPosition(cEvent->pos());
        if (face != -1) {
 //           cout << "Event !" << endl;
            fWhite = face;
             fWhitePatch = pixelsPatch[fWhite];
           highlightPixel(face);
            highlightPatch(fWhitePatch);
 //           CalculatePatchColor();
            emit signalPixelDoubleClick(face);
       }
        else
        {
            fWhite = -1;
            fWhitePatch = -1;
            clearHighlightedPixels();
            clearHighlightedPatches();
        }
        updateGL();

    }

     void QCameraWidget::SetWhite(int idx)
     {
         fWhite = idx;
         fWhitePatch = pixelsPatch[fWhite];
         if (isVisible())
             updateGL();
//         CalculatePatchColor();
     }
     void QCameraWidget::SetEnable(int idx, bool b)
     {
         fEnable[idx] = b;
     }

     double QCameraWidget::GetData(int idx)
     {
         return fData[idx];
     }
     void QCameraWidget::SetMin(int64_t min)
     {
 //        cout << "min: " << min << endl;
         fMin = min;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::SetMax(int64_t max)
     {
 //        cout << "max: " << max << endl;
         fMax = max;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     const char* QCameraWidget::GetName()
     {
         return "QCameraWidget";
     }
     char *QCameraWidget::GetObjectInfo(int px, int py)
     {

         static stringstream stream;
         static string str;
         const int pixel = this->PixelAtPosition(QPoint(px, py));
         if (pixel >= 0)
         {
             stream << "Pixel=" << pixel << "   Data=" << fData[pixel] << '\0';
         }
         str = stream.str();
         return const_cast<char*>(str.c_str());
     }
     void QCameraWidget::CalculatePixelsColor()
     {
         double dmin = fData[0];
          double dmax = fData[0];
          if (fMin < 0 || fMax < 0)
          {
              for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
              {
                  if (!fEnable[i]) continue;
                  if (fData[i] > dmax) dmax = fData[i];
                  if (fData[i] < dmin) dmin = fData[i];
              }
          }
          if (fMin >= 0) dmin = fMin;
          if (fMax >= 0) dmax = fMax;
//          cout << "min: " << dmin << " max: " << dmax << " fMin: " << fMin << " fMax: " << fMax << endl;
          float color;
          for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
           {
              if (!fEnable[i])
              {
//                  cout << "not enabled !" << i << endl;
                  pixelsColor[i][0] = 0.1f;
                  pixelsColor[i][1] = 0.1f;
                  pixelsColor[i][2] = 0.15f;
                  continue;
              }
              if (fData[i] < dmin)
               {
                   pixelsColor[i][0] = tooLowValueCoulour[0];
                   pixelsColor[i][1] = tooLowValueCoulour[1];
                   pixelsColor[i][2] = tooLowValueCoulour[2];
                   continue;
               }
               if (fData[i] > dmax)
               {
                   pixelsColor[i][0] = tooHighValueCoulour[0];
                   pixelsColor[i][1] = tooHighValueCoulour[1];
                   pixelsColor[i][2] = tooHighValueCoulour[2];
                   continue;
               }
               color = float((fData[i]-dmin)/(dmax-dmin));
               if (logScale)
               {
                   color *= 9;
                   color += 1;
                   color = log10(color);
               }

               int index = 0;
               while (ss[index] < color && index < 4)
                   index++;
               index--;
               if (index < 0) index = 0;
               float weight0 = (color-ss[index]) / (ss[index+1]-ss[index]);
               if (weight0 > 1.0f) weight0 = 1.0f;
               if (weight0 < 0.0f) weight0 = 0.0f;
               float weight1 = 1.0f-weight0;
               pixelsColor[i][0] = weight1*rr[index] + weight0*rr[index+1];
               pixelsColor[i][1] = weight1*gg[index] + weight0*gg[index+1];
               pixelsColor[i][2] = weight1*bb[index] + weight0*bb[index+1];
          }
          CalculatePatchColor();
          UpdateText();
          pixelColorUpToDate = true;
     }
     void QCameraWidget::CalculatePatchColor()
     {
         return;
         //calculate the patch contour color. let's use the anti-colour of the pixels
         GLfloat averagePatchColour[3] = {0.0f,0.0f,0.0f};
         for (int i=0;i<9;i++)
             for (int j=0;j<3;j++)
                 averagePatchColour[j] += pixelsColor[softwareMapping[patches[fWhitePatch][i]]][j];
         for (int j=0;j<3;j++)
             averagePatchColour[j] /= 9;
         for (int j=0;j<3;j++)
             patchColour[j] = 1.0f - averagePatchColour[j];
     }
     void QCameraWidget::SetData(const valarray<double> &ddata)
     {
//             fData = ddata;
         for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
             fData[i] = ddata[i];
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::UpdateText()
     {
         ostringstream str;
         float min, max, mean, rms, median;
         min = max = fData[0];
         mean = 0;
         rms = 0;
         median = 0;
         multiset<double> medianSet;
         for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
         {
             if (fData[i] < min)
                 min = fData[i];
             if (fData[i] > max)
                 max = fData[i];
             mean += fData[i];
             rms += fData[i]*fData[i];
             medianSet.insert(fData[i]);
         }
         mean /= ACTUAL_NUM_PIXELS;
         rms /= ACTUAL_NUM_PIXELS;
         rms = sqrt(rms);
 //        cout << "Size of the set: " << medianSet.size() << endl;
         multiset<double>::iterator it = medianSet.begin();
         for (int i=0;i<(ACTUAL_NUM_PIXELS/2)-1;i++)
             it++;
         median = *it;
         it++;
         median += *it;
         median /= 2;

         str << "Min: " << min << " Max: " << max << " Mean: " << mean << " RMS: " << rms << " Median: " << median;
         str << " Units: " << unitsText;
         dataText = str.str();
     }
     void QCameraWidget::DrawCameraText()
     {
         glPushMatrix();
         glLoadIdentity();
//         cout << width() << " " << height() << endl;
         int textSize = (int)(height()*14/600);
         setFont(QFont("Times", textSize));
         qglColor(QColor(255,223,127));
         float shiftx = 0.01f;//0.55f;
         float shifty = 0.01f;//0.65f;
         renderText(-shownSizex/2.f + shiftx, -shownSizey/2.f + shifty, 0.f, QString(dataText.c_str()));


         int textLength = titleText.size();
         renderText(-shownSizex/2.f + shiftx, shownSizey/2.f - textSize*pixelSize - shifty, 0.f, QString(titleText.c_str()));

         glPopMatrix();
     }
     void QCameraWidget::DrawScale()
     {
         glPushMatrix();
         glLoadIdentity();
         glPushAttrib(GL_POLYGON_BIT);
         glShadeModel(GL_SMOOTH);
         glBegin(GL_QUADS);
         float oneX = shownSizex/2.f - shownSizex/50.f;
         float twoX = shownSizex/2.f;
         float oneY = -shownSizey/2.f;
         float twoY = -shownSizey/4.f;
         float threeY = 0;
         float fourY = shownSizey/4.f;
         float fiveY = shownSizey/2.f;
         glColor3f(rr[0], gg[0], bb[0]);
         glVertex2f(oneX, oneY);
         glVertex2f(twoX, oneY);
         glColor3f(rr[1], gg[1], bb[1]);
         glVertex2f(twoX, twoY);
         glVertex2f(oneX, twoY);

         glVertex2f(oneX, twoY);
         glVertex2f(twoX, twoY);
         glColor3f(rr[2], gg[2], bb[2]);
         glVertex2f(twoX, threeY);
         glVertex2f(oneX, threeY);

         glVertex2f(oneX, threeY);
         glVertex2f(twoX, threeY);
         glColor3f(rr[3], gg[3], bb[3]);
         glVertex2f(twoX, fourY);
         glVertex2f(oneX, fourY);

         glVertex2f(oneX, fourY);
         glVertex2f(twoX, fourY);
         glColor3f(rr[4], gg[4], bb[4]);
         glVertex2f(twoX, fiveY);
         glVertex2f(oneX, fiveY);
         float zeroX = oneX - shownSizex/50.f;
         float zeroY = fiveY - shownSizey/50.f;
         glColor3fv(tooHighValueCoulour);
         glVertex2f(zeroX, fiveY);
         glVertex2f(oneX, fiveY);
         glVertex2f(oneX, zeroY);
         glVertex2f(zeroX, zeroY);
         glColor3fv(tooLowValueCoulour);
         glVertex2f(zeroX, -fiveY);
         glVertex2f(oneX, -fiveY);
         glVertex2f(oneX, -zeroY);
         glVertex2f(zeroX, -zeroY);
         glEnd();
         //draw linear/log tick marks
         glColor3f(0.f,0.f,0.f);
         glBegin(GL_LINES);
         float value;
         for (int i=1;i<10;i++)
         {
             if (logScale)
                 value = log10(i);
             else
                 value = (float)(i)/10.f;
             float y = -shownSizey/2.f + value*shownSizey;
             glVertex2f(oneX, y);
             glVertex2f(twoX, y);
         }
         glEnd();
         glPopAttrib();
         glPopMatrix();
     }
     void QCameraWidget::setUnits(const string& units)
     {
         unitsText = units;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::setTitle(const string& title)
     {
         titleText = title;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::linearScalePlease(bool checked)
     {
         if (!checked) return;
         logScale = false;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::logScalePlease(bool checked)
     {
         if (!checked) return;
         logScale = true;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::regularPalettePlease(bool checked)
     {
         if (!checked) return;
         ss[0] = 0;    ss[1] = 0.25f; ss[2] = 0.5f; ss[3] = 0.75f; ss[4] = 1.0f;
         rr[0] = 0.15; rr[1] = 0;     rr[2] = 0;    rr[3] = 1.0f;  rr[4] = 0.85f;
         gg[0] = 0.15; gg[1] = 0;     gg[2] = 1;    gg[3] = 0;     gg[4] = 0.85f;
         bb[0] = 0.15; bb[1] = 1;     bb[2] = 0;    bb[3] = 0;     bb[4] = 0.85f;
         tooHighValueCoulour[0] = 1.f;
         tooHighValueCoulour[1] = 1.f;
         tooHighValueCoulour[2] = 0.f;
         tooLowValueCoulour[0] = 0.f;
         tooLowValueCoulour[1] = 1.f;
         tooLowValueCoulour[2] = 1.f;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::prettyPalettePlease(bool checked)
     {
         if (!checked) return;
         ss[0] = 0.f;    ss[1] = 0.25f; ss[2] = 0.5f; ss[3] = 0.75f; ss[4] = 1.0f;
         rr[0] = 0.f; rr[1] = 0.35f;     rr[2] = 0.85f;    rr[3] = 1.0f;  rr[4] = 1.f;
         gg[0] = 0.f; gg[1] = 0.10f;     gg[2] = 0.20f;    gg[3] = 0.73f;     gg[4] = 1.f;
         bb[0] = 0.f; bb[1] = 0.03f;     bb[2] = 0.06f;    bb[3] = 0.00f;     bb[4] = 1.f;
         tooHighValueCoulour[0] = 0.f;
         tooHighValueCoulour[1] = 1.f;
         tooHighValueCoulour[2] = 0.f;
         tooLowValueCoulour[0] = 0.f;
         tooLowValueCoulour[1] = 0.f;
         tooLowValueCoulour[2] = 1.f;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::greyScalePalettePlease(bool checked)
     {
         if (!checked) return;
         ss[0] = 0;    ss[1] = 0.25f; ss[2] = 0.5f; ss[3] = 0.75f; ss[4] = 1.0f;
         rr[0] = 0; rr[1] = 0.25f;     rr[2] = 0.5f;    rr[3] = 0.75f;  rr[4] = 1.0f;
         gg[0] = 0; gg[1] = 0.25f;     gg[2] = 0.5f;    gg[3] = 0.75f;     gg[4] = 1.0f;
         bb[0] = 0; bb[1] = 0.25f;     bb[2] = 0.5f;    bb[3] = 0.75f;     bb[4] = 1.0f;
         tooHighValueCoulour[0] = 0.f;
         tooHighValueCoulour[1] = 1.f;
         tooHighValueCoulour[2] = 0.f;
         tooLowValueCoulour[0] = 0.f;
         tooLowValueCoulour[1] = 0.f;
         tooLowValueCoulour[2] = 1.f;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::glowingPalettePlease(bool checked)
     {
         if (!checked) return;
         ss[0] = 0;    ss[1] = 0.25f; ss[2] = 0.5f; ss[3] = 0.75f; ss[4] = 1.0f;
         rr[0] = 0.15; rr[1] = 0.5;     rr[2] = 1.f;    rr[3] = 0.0f;  rr[4] = 1.f;
         gg[0] = 0.15; gg[1] = 0.5;     gg[2] = 1.f;    gg[3] = 0.5f;     gg[4] = 0.5f;
         bb[0] = 0.15; bb[1] = 0.5;     bb[2] = 1;      bb[3] = 1.f;     bb[4] = 0.f;
         tooHighValueCoulour[0] = 1.f;
         tooHighValueCoulour[1] = 0.f;
         tooHighValueCoulour[2] = 0.f;
         tooLowValueCoulour[0] = 0.f;
         tooLowValueCoulour[1] = 1.f;
         tooLowValueCoulour[2] = 0.f;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::zeroRotationPlease(bool checked)
     {
         if (!checked) return;
         cameraRotation = 0;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::plus90RotationPlease(bool checked)
     {
         if (!checked) return;
         cameraRotation = 90;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::minus90RotationPlease(bool checked)
     {
         if (!checked) return;
         cameraRotation = -90;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::highlightPixel(int idx)
     {
         if (idx < 0 || idx > ACTUAL_NUM_PIXELS)
         {
           cout << "Error: requested pixel highlight out of bounds" << endl;
           return;
         }
         highlightedPixels.push_back(idx);
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::highlightPatch(int idx)
     {
         if (idx < 0 || idx > NTMARK)
         {
             cout << "Error: requested patch highlight out of bounds" << endl;
             return;
         }
         highlightedPatches.push_back(idx);
         if (isVisible())
             updateGL();

     }
     void QCameraWidget::clearHighlightedPatches()
     {
         highlightedPatches.clear();
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::clearHighlightedPixels()
     {
         highlightedPixels.clear();
         if (isVisible())
             updateGL();
     }




