#ifndef Q_CAMERA_WIDGET_H_
#define Q_CAMERA_WIDGET_H_

#include "BasicGlCamera.h"
#include <valarray>
#include <set>


using namespace std;

class QCameraWidget : public BasicGlCamera
{
    Q_OBJECT

    typedef pair<double, double> Position;
    typedef vector<Position> Positions;

    Positions fGeom;

    vector<bool> fBold;
    vector<bool> fEnable;

    vector<int> highlightedPatches;
    vector<int> highlightedPixels;


    int lastFace;


public:
    void highlightPixel(int idx, bool highlight=true);
    void highlightPatch(int idx, bool highlight=true);
    void clearHighlightedPatches();
    void clearHighlightedPixels();
    QCameraWidget(QWidget *pparent = 0);
    void paintGL();
    void mousePressEvent(QMouseEvent *cEvent);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseDoubleClickEvent(QMouseEvent *event);
    void Reset();
    void drawCamera(bool alsoWire);
    void drawPatches();
     void SetEnable(int idx, bool b);
     double GetData(int idx);
    const char *GetName();

     int GetIdx(float px, float py);
     char *GetObjectInfo(int px, int py);

     void SetData(const valarray<double> &ddata);


private:
     void CalculatePixelsColor();
     void CalculatePatchColor();

};

typedef QCameraWidget Camera;
#endif
