// Get ftm connected, idle and with working FTUs
function handleFtmIdle(wait_state)
{
    var state = dim.state("FTM_CONTROL");
    if (state===undefined)
        return undefined;

    // Only try to open the service if the server is already in the list
    if (wait_state && wait_state.length>0 && state.name!=wait_state)
        return wait_state;

    //dim.print("FTM_CONTROL:  "+state.name+"["+state.index+"]");

    switch (state.name)
    {
    case "Disconnected":
        console.out("Ftm in "+state.name+"... connect.");
        dim.send("FTM_CONTROL/RECONNECT");
        return "Idle";

    case "Idle":
        //ftu_counter = data.counter;
        return "";

    case "TriggerOn":
        console.out("Ftm in "+state.name+"... stop trigger.");
        dim.send("FTM_CONTROL/STOP_TRIGGER");
        return "Idle";
 
    case "Configuring1":
    case "Configuring2":
    case "Configured":
        console.out("Ftm in "+state.name+"... reset configuration.");
        dim.send("FTM_CONTROL/RESET_CONFIGURE");
        return "Idle";

    case "ConfigError1":
    case "ConfigError2":
    case "ConfigError3":
        throw new Error("FTM_CONTROL:"+state.name+"["+state.index+"] in error state.");
    }

    throw new Error("FTM_CONTROL:"+state.name+"["+state.index+"] unknown or not handled.");
}
