'use strict';


// This list of objects is currently used by Main.js
// to build up the nightly schedule for FACT.
//
// one can define some 'tasks' like: "STARTUP", "SHUTDOWN", "RATESCAN" and "DATA"
// for the latter two, one should define a 'source' parameter as well.
// This must be a string which is contained in FACTs list of sources.
// The Ratescan can as well get ra and dec coordinates
// In case one does not specify a task "DATA" is assumed.
// example:
/*
var observations = [
    { date:"2013-01-09 21:05 UTC", task:'startup' },
    { date:"2013-01-09 21:20 UTC", task:'ratescan', source:'Dark Patch 3' },
    { date:"2013-01-09 21:21 UTC", source:'Crab'},
    { date:"2013-01-10 04:44 UTC", task:'ratescan', source:'Dark Patch 3'},
    { date:"2013-01-10 04:45 UTC", task:'data', source:'Mrk 421'},
    { date:"2013-01-10 04:44 UTC", task:'ratescan', ra:3.1415, dec:3.1415},
    { date:"2013-01-10 04:44 UTC", task:'shutdown'} ];
*/

// technical information. 
// the objects (i.e. the stuff in curly braces {}) 
// in this list are used to create 
// instances of Observation-objects as defined in Object_class.js
// so in case one is interested details of this interface, that is 
// the place to look.

var observations = [
//    { date:"2013-01-09 21:05 UTC", task:'startup' },
    { date:"2013-01-09 17:50 UTC", task:'ratescan', source:'Dark Patch 3' },
//    { date:"2013-01-09 21:21 UTC", source:'Crab'},
//    { date:"2013-01-10 04:44 UTC", task:'ratescan', source:'Dark Patch 3'},
//    { date:"2013-01-10 04:45 UTC", task:'data', source:'Mrk 421'},
//    { date:"2013-01-10 04:44 UTC", task:'ratescan', ra:3.1415, dec:3.1415},
//    { date:"2013-01-10 04:44 UTC", task:'shutdown'} ];

