// Get Drive control armed
function handleDriveArmed(wait_state)
{
    var state = dim.state("DRIVE_CONTROL");
    if (state===undefined)
        return undefined;

    if (wait_state && wait_state.length>0 && state.name!=wait_state)
        return wait_state;

    dim.log("DRIVE_CONTROL: "+state.name+"["+state.index+"]");

    switch (state.name)
    {
    case "Disconnected":
    case "Connected":
    case "NotReady":
    case "Ready":
        v8.sleep(1000);
        return undefined;

    case "Locked":
        throw new Error("Drive is LOCKED. Please unlock manually.");
        //return undefined;
        //dim.log("Drive in Locked... unlock.");
        //dim.send("DRIVE_CONTROL/UNLOCK");
        //return "Armed";

    case "Moving":
    case "Tracking":
    case "OnTrack":
        dim.log("Drive moving... stop.");
        dim.send("DRIVE_CONTROL/STOP");
        return "Armed";

    case "ERROR":
        dim.log("Drive in error... trying to reinitialize.");
        dim.send("DRIVE_CONTROL/STOP");
        dim.wait("DRIVE_CONTROL", "Armed", 5000);
        return undefined;  // Process that again if necessary

    case "Armed":
        return "";
    }

    throw new Error("DRIVE_CONTROL:"+state.name+"["+state.index+"] unknown or not handled.");
}
