#ifndef FACT_Converter
#define FACT_Converter

#include <vector>
#include <ostream>

class Converter
{
private:
    bool rc;
    std::ostream &wout;
    std::vector<char> data;

    template<class V>
        void Eval(int i, std::stringstream &line, std::vector<char> &vec) const;

    template<class T>
        std::string Get(const char *&data) const;

public:
    Converter(std::ostream &out, const std::string &fmt, const std::string &str);
    Converter(std::ostream &out, const std::string &fmt, const void *d, int size);

    const char *Ptr() const { return &*data.begin(); }
    const std::string Str() const { return std::string(&*data.begin(), data.size()); }
    char *Ptr() { return &*data.begin(); }
    int   Size() const { return data.size(); }
    bool  GetRc() const { return rc; }


};

#endif
