#include <boost/regex.hpp>
#include <readline/readline.h>

#include "tools.h"
#include "Time.h"
#include "StateMachineDim.h"
#include "MessageDim.h"
#include "Shell.h"
#include "ServiceList.h"
#include "Configuration.h"

using namespace std;

#include "RemoteControl.h"

template <class T>
void RunShell(Configuration &conf)
{
    // A normal kill will call its destructor! (Very nice feature ;) )
    static T shell(conf.GetName().c_str(), conf.Get<int>("console")!=1);

    WindowLog &win  = shell.GetStreamIn();
    WindowLog &wout = shell.GetStreamOut();

    if (conf.Has("log"))
        if (!wout.OpenLogFile(conf.Get<string>("log")))
            win << kRed << "ERROR - Couldn't open log-file " << conf.Get<string>("log") << ": " << strerror(errno) << endl;

    shell.Run();
}


// ========================================================================
void SetupConfiguration(Configuration &conf)
{
    const string n = conf.GetName()+".log";

    po::options_description config("Configuration");
    config.add_options()
        ("log,l",     var<string>(n), "Write log-file")
        ("console,c", var<int>(),     "Use console (0=shell, 1=simple buffered, X=simple unbuffered)")
        ;

    conf.AddOptionsCommandline(config);
}

int main(int argc, char *argv[])
{
    cout << "Starting " << argv[0] << "..." << endl;

    // We could use putenv to make the Configure class change the value...
    setenv("DIM_DNS_NODE", "localhost", 0);

    Configuration conf(argv[0]);
    SetupConfiguration(conf);

    po::variables_map vm;
    try
    {
        vm = conf.Parse(argc, argv);
    }
    catch (std::exception &e)
    {
        po::multiple_occurrences *MO = dynamic_cast<po::multiple_occurrences*>(&e);
        if (MO)
            cout << "Error: " << e.what() << " of '" << MO->get_option_name() << "' option." << endl;
        else
            cout << "Error: " << e.what() << endl;
        cout << endl;

        return -1;
    }

    if (conf.HasHelp() || conf.HasPrint())
        return -1;

    if (conf.Get<int>("console")==0)
        RunShell<RemoteShell>(conf);
    else
        RunShell<RemoteConsole>(conf);


    return 0;
}
