#ifndef FACT_Converter
#define FACT_Converter

#include <vector>
#include <ostream>

#include <boost/any.hpp>

class Converter
{
private:
    bool rc;                        /// Flag for the success of the conversion
    std::ostream &wout;             /// ostream to which output is redirected
    std::vector<char> data;         /// data storage
    std::vector<boost::any> vec;    /// storage for typed data

    template<class T>
        void EvalImp(int i, std::stringstream &line, std::vector<char> &v, const T &val);
    template<class T>
        void Eval(int i, std::stringstream &line, std::vector<char> &v);
        void EvalBool(int i, std::stringstream &line, std::vector<char> &v);
        void EvalString(int i, std::stringstream &line, std::vector<char> &v);

    template<class T>
        std::string Get(const char *&data);

public:
    Converter(std::ostream &out, const std::string &fmt, const std::string &str);
    Converter(std::ostream &out, const std::string &fmt, const void *d, int size);

    /// Returns whether the conversion was successfull
    bool GetRc() const { return rc; }

    /// const Pointer to the data memory
    const char *Ptr() const { return &*data.begin(); }
    /// non-const Pointer to the data memory (for convinience using Dim)
    char *Ptr() { return &*data.begin(); }

    /// Return the size of the data memory
    int  Size() const { return data.size(); }

    /// Return the data memory converted into a string (not necessarily \0-terminated)
    const std::string Str() const { return std::string(&*data.begin(), data.size()); }


    // Returns the number of entries in Converter:vec
    int N() const { return vec.size(); }

    /// Checks if an entry with the given class type is available at index i in Converter::vec
    template <class T>
        bool Has(unsigned int i) const { return i<vec.size() && vec[i].type()==typeid(T); }

    /// return the entry with the given class type at index i from Converter::vec (exception safe)
    template <class T>
        T Get(int i) const { return !Has<T>(i) ? T() : boost::any_cast<T>(vec[i]); }

    /// return the entry with the given class type at index i from Converter::vec (throws exceptions)
    template <class T>
        T At(int i) const { return boost::any_cast<T>(vec[i]); }


    static std::vector<std::string> Regex(const std::string &expr, const std::string &line);
};

#endif
