#ifndef FACT_MessageDim
#define FACT_MessageDim

#include "MessageImp.h"



#include <dis.hxx> // DimService

class MessageDimTX : public DimService, public MessageImp
{
private:
    bool fDebug;

public:
    MessageDimTX(const std::string &name, std::ostream &out=std::cout);
    ~MessageDimTX();

    int Write(const Time &t, const std::string &txt, int qos=kInfo);

    void SetDebug(bool b=true) { fDebug=b; }
};



#include <dic.hxx> // DimStampedInfo

class MessageDimRX : public DimInfoHandler
{
protected:
    MessageImp &fMsg;

private:
    DimStampedInfo fDimMessage;

    int  fMinLogLevel;
    bool fConnected;

protected:
    void infoHandler();

public:
    MessageDimRX(const std::string &name, MessageImp &imp);

    void SetMinLogLevel(int min=0) { fMinLogLevel=min; }
    bool IsConnected() const { return fConnected; }
};

#endif
