#include "RemoteControl.h"

// ==========================================================================

bool RemoteControlImp::ProcessCommand(const std::string &str)
{
    if (fCurrentServer.empty())
    {
        const size_t p1 = str.find_first_of(' ');
        const size_t p2 = str.find_first_of('/');

        string s = str;
        if (p2!=string::npos && p1>p2)
            s = str.substr(0, p2);

        if (p2<p1)
        {
            const string c = str.substr(p2+1);
            return !SendDimCommand(lout, s, c);
        }

        if (HasServer(s))
        {
            fCurrentServer = s;
            return false;
        }
        lout << kRed << "Unkown server '" << s << "'" << endl;
        return true;
    }

    if (!fCurrentServer.empty() && str=="..")
    {
        fCurrentServer = "";
        return false;
    }

    return !SendDimCommand(lout, fCurrentServer, str);
}

// ==========================================================================

#include "tools.h"

string RemoteConsole::GetUpdatePrompt() const
{
    // If we are continously flushing the buffer omit the buffer size
    // If we are buffering show the buffer size
    const string beg = "\n" + GetLinePrompt();

    // If we have not cd'ed to a server show only the line start
    if (fCurrentServer.empty())
        return beg + "> ";

    // Check if we have cd'ed to a valid server
    const ClientList::const_iterator l = fClientList.find(fCurrentServer);
    if (l==fClientList.end())
        return beg + "> ";//Form("\n[%d] \033[34m\033[1m%s\033[0m> ", GetLine(), fCurrentServer.c_str());

    const State state = GetState(fCurrentServer, l->second->GetState());

    // The server
    const string serv = Form("\033[34m\033[1m%s\033[0m", fCurrentServer.c_str());

    // If no match found or something wrong found just output the server
    if (state.index<-1)
        return beg + " " + serv + "> ";

    // If everything found add the state to the server
    return beg + " " + serv + ":\033[32m\033[1m" + state.name + "\033[0m> ";
}

string RemoteShell::GetUpdatePrompt() const
{
    // If we are continously flushing the buffer omit the buffer size
    // If we are buffering show the buffer size
    const string beg = GetLinePrompt();

    // If we have not cd'ed to a server show only the line start
    if (fCurrentServer.empty())
        return beg + "> ";

    // Check if we have cd'ed to a valid server
    const ClientList::const_iterator l = fClientList.find(fCurrentServer);
    if (l==fClientList.end())
        return beg + "> ";//Form("\n[%d] \033[34m\033[1m%s\033[0m> ", GetLine(), fCurrentServer.c_str());

    const State state = GetState(fCurrentServer, l->second->GetState());

    // If no match found or something wrong found just output the server
    if (state.index<-1)
        return beg + " " + fCurrentServer + "> ";

    // If everything found add the state to the server
    return beg + " " + fCurrentServer + ":" + state.name + "> ";
}
