#ifndef FACT_DimDescriptionService
#define FACT_DimDescriptionService

#include <string>

class DimService;

class DimDescriptionService
{
    static int         fCount;     /// Counter to count the number of instatiations
    static DimService *fService;   /// Pointer to the DimService distributing the desscriptions
    static std::string fData;      /// Data to be distributed with the service

    std::string fDescription;      /// Local storage for the applied description

public:
    DimDescriptionService(const std::string &name, const std::string &format);
    ~DimDescriptionService();

    std::string GetDescription() const { return fDescription; }
};

#include "dis.hxx"

class DimDescribedService : public DimDescriptionService, public DimService
{
public:
    template<typename T>
        DimDescribedService(const char *name, T &val, const char *desc)
        : DimDescriptionService(name, desc), DimService(name, val)
    {
    }

    DimDescribedService(const char *name, const char *val, const char *desc)
        : DimDescriptionService(name, desc), DimService(name, const_cast<char*>(val)) { }

    DimDescribedService(const char *name, const char *format, void *structure, int size, const char *desc)
        : DimDescriptionService(name, desc), DimService(name, format, structure, size)
    {
        // FIXME: compare number of ; with number of |
    }
};


#endif
