// **************************************************************************
/** @class DimErrorRedirecter

*/
// **************************************************************************
#include "DimErrorRedirecter.h"

#include <dic.hxx>

#include "WindowLog.h"
#include "MessageImp.h"

using namespace std;

int DimErrorRedirecter::cnt = 0;

DimErrorRedirecter::DimErrorRedirecter(MessageImp &imp) : fMsg(imp)
{
    if (cnt++)
    {
        fMsg.Error("ERROR - More than one instance of MyHandlers.");
        exit(-1);
    }

    dic_disable_padding();
    dis_disable_padding();

    DimServer::addExitHandler(this);
    DimServer::addErrorHandler(this);
    DimClient::addErrorHandler(this);
}

DimErrorRedirecter::~DimErrorRedirecter()
{
    DimClient::addErrorHandler(0);
    DimServer::addErrorHandler(0);
    DimServer::addExitHandler(0);
}

void DimErrorRedirecter::errorHandler(int severity, int code, char *msg)
{
    static const string id = "DIM|";

    switch (severity)
    {
    case DIM_FATAL:   fMsg.Error(id+msg); break;
    case DIM_ERROR:   fMsg.Error(id+msg); break;
    case DIM_WARNING: fMsg.Warn(id+msg);  break;
    case DIM_INFO:    fMsg.Info(id+msg);  break;
    default:
        stringstream str;
        str << "DIM message with unknown severity (" << severity << "): ";
        str << msg << " (" << code << ")";
        fMsg.Message(str);
        break;
    }

    // If the severity is FATAL after this the exitHandler
    // is called with the errorcode by dim

    //if (severity==DIM_FATAL && code==DIMDNSDUPLC)
    //    exit(3);//abort();


    /*
     DIMDNSUNDEF	DIM_FATAL	DIM_DNS_NODE undefined
     DIMDNSREFUS	DIM_FATAL	DIM_DNS refuses connection
     DIMDNSDUPLC	DIM_FATAL	Service already exists in DNS
     DIMDNSEXIT	        DIM_FATAL	DNS requests server to EXIT
     DIMDNSTMOUT	DIM_WARNING	Server failed sending Watchdog

     DIMDNSCNERR	DIM_ERROR	Connection to DNS failed
     DIMDNSCNEST	DIM_INFO	Connection to DNS established

     DIMSVCDUPLC	DIM_ERROR	Service already exists in Server
     DIMSVCFORMT	DIM_ERROR	Bad format string for service
     DIMSVCINVAL	DIM_ERROR	Invalid Service ID

     DIMTCPRDERR	DIM_ERROR	TCP/IP read error
     DIMTCPWRRTY	DIM_WARNING	TCP/IP write error - Retrying
     DIMTCPWRTMO	DIM_ERROR	TCP/IP write error - Disconnected
     DIMTCPLNERR	DIM_ERROR	TCP/IP listen error
     DIMTCPOPERR	DIM_ERROR	TCP/IP open server error
     DIMTCPCNERR	DIM_ERROR	TCP/IP connection error
     DIMTCPCNEST	DIM_INFO	TCP/IP connection established
     */
}

