#include <iostream>
#include <dic.hxx>

#include "Configuration.h"

using namespace std;



void SetupConfiguration(Configuration &conf)
{
    const string n = conf.GetName()+".log";

    //po::options_description config("Program options");
    po::options_description config("Configuration");
    config.add_options()
        ("dns",       var<string>("localhost"),  "Dim nameserver host name (Overwites DIM_DNS_NODE environment variable)")
        ("log,l",     var<string>(n), "Write log-file")
        //("no-dim,d",  po_switch(),    "Disable dim services")
        //("console,c", var<int>(),     "Use console (0=shell, 1=simple buffered, X=simple unbuffered)")
        ("dbname",    var<string>(),      "database name for scheduling preview")
        ;

    conf.AddEnv("dns", "DIM_DNS_NODE");

    conf.AddOptions(config);
}



int main(int argc, const char* argv[])
{
    Configuration conf(argv[0]);
    SetupConfiguration(conf);

    po::variables_map vm;
    try
    {
        vm = conf.Parse(argc, argv);
    }
    catch (std::exception &e)
    {
#if BOOST_VERSION > 104000
        po::multiple_occurrences *MO = dynamic_cast<po::multiple_occurrences*>(&e);
        if (MO)
            cout << "Error: " << e.what() << " of '" << MO->get_option_name() << "' option." << endl;
        else
#endif
            cout << "Error: " << e.what() << endl;
        cout << endl;

        return -1;
    }

    const char* dbname;
    if (conf.Has("dbname"))
        dbname = conf.Get<string>("dbname").c_str();
    else
    {
        cout << "Please provide which database you want to use for scheduling using --dbname=<dbname>." << endl;
        return -1;
    }


    if (conf.HasHelp() || conf.HasPrint())
        return -1;

    // To allow overwriting of DIM_DNS_NODE set 0 to 1
    setenv("DIM_DNS_NODE", conf.Get<string>("dns").c_str(), 1);

//int main ()
//{

    int value;

    value = DimClient::sendCommand("SCHEDULER/SCHEDULE", dbname);
    //value = DimClient::sendCommand("SCHEDULER/SCHEDULE", NULL, 0);

    cout << "\n";
    cout << " The method sendCommand(...) will wait for the command to be actualy sent to the Server and return a completion code of : " << endl;
    cout << "                                   1 - if it was successfully sent  " << endl;
    cout << "                                   0 - if it couldn't be delivered. " << endl;

    cout << "\n";
    cout << " The completion code is now:       " << value << endl;

    return 0;

}
