#ifndef FACT_Fits
#define FACT_Fits

#include <CCfits/CCfits>
#include <vector>

#include "Description.h"

class Converter;
class MessageImp;

class Fits
{
	private:
		///The CCfits object to the FITS file
                CCfits::FITS* fFile;
		///Flag indicating whether the FITS object should be managed internally or not.
		bool fOwner;
		///The CCfits Table
		CCfits::Table* fTable;
		///The current number of Rows in the table
		int fNumRows;
		///Name of the "standard", i.e. data found in every fits file
		///TODO make these variable static so that they are shared by every object.
		///TODO add also a static boolean to initialize these only once
		std::vector<Description> fStandardColDesc;
		///Format of the standard columns.
		std::vector<std::string> fStandardFormats;
		///the pointers to the standard variables
		std::vector<void*> fStandardPointers;
		///the number of bytes taken by each standard variable
		std::vector<int> fStandardNumBytes;
		///the vector of data column names
		std::vector<Description> fDataColDesc;
		///the data format of the data columns
		std::vector<std::string> fDataFormats;
		///the pointer to the contiguous memory location where the data is stored (i.e. the dim data pointer)
		void* fDataPointer;
		///the size of the data, in bytes.
		int fDataNumBytes;
		///the copy buffer. Required to put the standard and data variable in contguous memory 
		unsigned char* fCopyBuffer;
		///the total number of bytes per FITS row
		int fTotalNumBytes;
		///to keep track of the time of the latest written entry (to update the header when closing the file)
		double fEndMjD;
		///to keep track of the reference MjD
		double fRefMjD;
		///Write the FITS header keys
		void WriteHeaderKeys();
public:
		///Name of the openned file. For querying stats
		std::string fFileName;
private:
		///Keep track of number of opened fits
		int* fNumOpenFitsFiles;
		///were to log the errors
		MessageImp* fMess;		
	public:
		
		Fits() :  fFile(NULL),
				  fOwner(false),
				  fTable(NULL), 
					 fNumRows(0), 
					 fDataPointer(NULL), 
					 fDataNumBytes(0), 
					 fCopyBuffer(NULL), 
					 fTotalNumBytes(0),
					 fEndMjD(0.0),
					 fRefMjD(0.0),
					 fFileName(""),
					 fNumOpenFitsFiles(NULL),
					 fMess(NULL)
		 {}
		
		virtual ~Fits() 
		{
			if (IsOpen())
				Close();
		}
		///returns wether or not the file is currently open or not
		bool IsOpen() {return fFile != NULL;}
		
		///Adds a column that exists in all FITS files
		void AddStandardColumn(Description& desc, std::string dataFormat, void* dataPointer, long unsigned int numDataBytes);
		
		///Adds columns specific to the service being logged.
		void InitDataColumns(std::vector<Description> desc, std::vector<std::string>& dataFormat, void* dataPointer, int numDataBytes);

		///Opens a FITS file
                void Open(const std::string& fileName, const std::string& tableName, CCfits::FITS* file, int* fitsCounter, std::ostream& out);

		///Write one line of data. Use the given converter.
		void Write(Converter* conv);
		
		///Close the currently opened file.
		void Close();
		
		///Get the size currently written on the disk
		int GetWrittenSize();

};//Fits


#endif /*FITS_H_*/

