#ifndef FACT_Dim
#define FACT_Dim

#include <string>

#include "dic.hxx"

namespace Dim
{
    std::string GetLocalIp(const std::string &dns);
    void Setup(const std::string &dns);

    // --------------------------------------------------------------------------
    //
    //! Simplification wrapper to send a command without data
    //!
    //! Example:
    //!   - Dim::SendCommand("SERVER/COMMAND");
    //!
    //! @param command
    //!     Dim command identifier
    //!
    //! @returns
    //!     the return value of DimClient::sendCommand
    //!
    inline bool SendCommand(const std::string &command)
    {
        return DimClient::sendCommand(command.c_str(), NULL, 0);
    }

    // --------------------------------------------------------------------------
    //
    //! Simplification wrapper to send a command with the given data
    //!
    //! Example:
    //!   - Dim::SendCommand("SERVER/COMMAND", uint16_t(42));
    //!   - struct tm t; Dim::SendCommand("SERVER/TIME", t);
    //!
    //! @param command
    //!     Dim command identifier
    //!
    //! @param t
    //!     object to be sent, the pointer to the data to be sent is
    //!     set to &t
    //!
    //! @tparam T
    //!     type of the data to be sent. The size of the data to be sent
    //!     is determined as sizeof(T)
    //!
    //! @returns
    //!     the return value of DimClient::sendCommand
    //!
    template<typename T>
        inline bool SendCommand(const std::string &command, const T &t)
    {
        return DimClient::sendCommand(command.c_str(), (void*)&t, sizeof(t));
    }
}

#endif
