#include "HeadersFAD.h"

#include <string.h>

#include <iomanip>

#include "Converter.h"

using namespace std;

void FAD::EventHeader::print(std::ostream &out) const
{
    out << "Delimiter:  ";
    if (fStartDelimiter==kDelimiterStart)
        out << "ok";
    else
        out << hex << fStartDelimiter;
    out << " (Crate=" << dec << (fBoardId>>8) << ", Board=" << (fBoardId&0xff) << ", Version=" << (fVersion>>8) << "." << (fVersion&0xff) << ", DNA=" << hex << fDNA <<")" << endl;

    out << dec;
    out << "PkgLength:  " << fPackageLength << endl;

    out << "RunNumber:  " << fRunNumber << endl;
    out << "Time:       " << fTimeStamp/10000. << "s" << endl;
    out << "EvtCounter: " << fEventCounter << " of " << fNumTriggersToGenerate << endl;
    out << "Trigger:    Type=" << fTriggerType << " Id=" << fTriggerId << " Crc=0x" << hex << fTriggerCrc << endl;

    out << "RefClock:   " << dec << fFreqRefClock << endl;
    out << "PhaseShift: " << fAdcClockPhaseShift << endl;
    out << "Prescaler:  " << fTriggerGeneratorPrescaler << endl;

    out << "DAC:       " << dec;
    for (int i=0; i<kNumDac; i++)
        out << " " << fDac[i];
    out << endl;

    out << "Temp:      " << dec;
    for (int i=0; i<kNumTemp; i++)
        out << " " << GetTemp(i);
    out << endl;

    out << "Status=" << hex << fStatus << endl;
    // PllLock -> 1111
    out << "  RefClk locked (PLLLCK):  " << hex << (int)PLLLCK();
    if (IsRefClockTooHigh())
        out << " (too high)";
    if (IsRefClockTooLow())
        out << " (too low)";
    out << endl;
    out << "  Domino wave (Denable):   " << (HasDenable()?"enabled":"disabled") << endl;
    out << "  DRS sampling (Dwrite):   " << (HasDwrite()?"enabled":"disabled") << endl;
    out << "  Dig.clock manager (DCM): " << (IsDcmLocked()?"locked":"unlocked");
    out << " / " << (IsDcmReady()?"ready":"not ready") << endl;
    out << "  SPI Serial Clock (SCLK): " << (HasSpiSclk()?"enabled":"disabled") << endl;
}

void FAD::ChannelHeader::print(std::ostream &out) const
{
    out << "Chip=" << dec << (fId>>4) << " Ch=" << (fId&0xf) << ":";
    out << " StartCell=" << fStartCell;
    out << " ROI=" << fRegionOfInterest << endl;
}
