#ifndef FACT_MessageDim
#define FACT_MessageDim

#include "MessageImp.h"



#include "DimDescriptionService.h"
//#include <dis.hxx> // DimService

class MessageDimTX : public DimDescribedService, public MessageImp
{
private:
    bool fDebug;

public:
    MessageDimTX(const std::string &name, std::ostream &out=std::cout);
    ~MessageDimTX();

    int Write(const Time &t, const std::string &txt, int qos=kInfo);

    void SetDebug(bool b=true) { fDebug=b; }
};



#include <dic.hxx> // DimStampedInfo

class MessageDimRX : public DimInfoHandler
{
private:
    int  fMinLogLevel;
    bool fConnected;

protected:
    MessageImp &fMsg;

private:
    DimStampedInfo fDimMessage;

protected:
    void infoHandler();

public:
    MessageDimRX(const std::string &name, MessageImp &imp);

    void SetMinLogLevel(int min=0) { fMinLogLevel=min; }
    bool IsConnected() const { return fConnected; }
};

#endif

// **************************************************************************
/** @class DimNetworkInfo

@brief Direct derivative of DimStampedInfo

Since secs and millisecs are not initialized in the base class
valgrind throws a couple of warnings debugging applications.

This derivative just initialized them with 0. It will be removed as
soon as the initialization was done in Dim itself.

**/
// **************************************************************************
