#ifndef FACT_DimDescriptionService
#define FACT_DimDescriptionService

#include <string>

class DimService;

class DimDescriptionService
{
    static int         fCount;     /// Counter to count the number of instatiations
    static DimService *fService;   /// Pointer to the DimService distributing the desscriptions
    static std::string fData;      /// Data to be distributed with the service

    std::string fDescription;      /// Local storage for the applied description

public:
    DimDescriptionService(const std::string &name, const std::string &format);
    ~DimDescriptionService();

    std::string GetDescription() const { return fDescription; }
};

#include "dis.hxx"

class DimDescribedService : public DimDescriptionService, public DimService
{
public:
    template<typename T>
    DimDescribedService(const std::string &name, const T &val, const char *desc)
        : DimDescriptionService(name.c_str(), desc), DimService(name.c_str(), const_cast<T&>(val))
    {
    }

    template<typename T>
    DimDescribedService(const std::string &name, const char *format, const T &val, const char *desc)
        : DimDescriptionService(name.c_str(), desc), DimService(name.c_str(), format, const_cast<T*>(&val), sizeof(T))
    {
    }

    DimDescribedService(const std::string &name, const char *format, const char *desc)
       : DimDescriptionService(name.c_str(), desc), DimService(name.c_str(), format, (void*)NULL, 0)
    {
        // FIXME: compare number of ; with number of |
    }
};

#endif
