#ifndef FACT_DataProcessorImp
#define FACT_DataProcessorImp

#include "MessageImp.h"

struct _RUN_HEAD;
struct _EVENT;
struct _RUN_TAIL;

typedef struct _RUN_HEAD RUN_HEAD;
typedef struct _EVENT    EVENT;
typedef struct _RUN_TAIL RUN_TAIL;

class DataProcessorImp : public MessageImp
{
    uint32_t fRunId;

    int Write(const Time &time, const std::string &txt, int qos)
    {
        return fMsg.Write(time, txt, qos);
    }

protected:
    MessageImp &fMsg;
    std::string fFileName;

public:
    DataProcessorImp(uint32_t id, MessageImp &imp) : fRunId(id), fMsg(imp) { }
    virtual ~DataProcessorImp() { }

    virtual bool Open(RUN_HEAD* h) = 0;
    virtual bool WriteEvt(EVENT *) = 0;
    virtual bool Close(RUN_TAIL * = 0) = 0;

    const std::string &GetFileName() const { return fFileName; }

    uint32_t GetRunId() const { return fRunId; }

    static std::string FormFileName(uint32_t runid, const std::string &extension);
};

#include "Time.h"

class DataDump : public DataProcessorImp
{
    Time fTime;

public:
    DataDump(uint32_t id, MessageImp &imp) : DataProcessorImp(id, imp) { }

    bool Open(RUN_HEAD* h);
    bool WriteEvt(EVENT *e);
    bool Close(RUN_TAIL * = 0);
};

class DataDebug : public DataDump
{
public:
    DataDebug(uint32_t id, MessageImp &imp) : DataDump(id, imp) { }

    bool WriteEvt(EVENT *e);
};

#endif
