#ifndef FACT_DataWriteFits
#define FACT_DataWriteFits

#include "DataProcessorImp.h"
#include "FitsFile.h"

class Converter;

class DataWriteFits : public DataProcessorImp
{
    Converter *fConv;

    FitsFile fFile;

    template <typename T>
        void WriteKey(const string &name, const int idx, const T &value, const string &comment);

    bool WriteFooter(RUN_TAIL *rt);

public:
    DataWriteFits(const std::string path, uint32_t runid, MessageImp &imp) :
        DataProcessorImp(path, runid, imp), fConv(0), fFile(imp)
    {
    }

    ~DataWriteFits();

    bool Open(RUN_HEAD* h);
    bool WriteEvt(EVENT *e);
    bool Close(RUN_TAIL *rt = 0);
};

#endif
