#ifndef FACT_EventBuilder
#define FACT_EventBuilder

#ifdef __cplusplus
extern "C" {
#endif

#include "FAD.h"

/* global variables; 
   to avoid race canoditions, only one thread is allowed to write 
   the name of the variable defines which process shall write it:

   g_XXX : main control thread
   gi_XX : input thread (reading from camera)
   gw_XX : write thread (writing to disk)
   qp_XX : processing thread(s) (processing data, eg. soft-trig)

*/
extern uint g_actTime   ;  //actual time, to be updated regularily
extern int  g_runStat   ;  //main steering variable
extern int  g_actBoards ;  //number of boards that should exist at the moment
extern int  g_reset     ;  //>0 = reset different levels of eventbuilder
extern int  g_maxProc   ;
extern size_t g_maxMem  ;  //maximum memory allowed for buffer

extern PIX_MAP g_pixMap[NPIX] ;

extern int  g_maxBoards ;  //maximum number of boards to be initialized
extern FACT_SOCK g_port[NBOARDS] ;  // .port = baseport, .addr=string of IP-addr in dotted-decimal "ddd.ddd.ddd.ddd"

extern uint gi_SecRate[MAX_SOCK] ;    //MAX_SOCK defined in FACTEvent.h
extern uint gi_S10Rate[MAX_SOCK] ;
extern uint gi_MinRate[MAX_SOCK] ;
extern uint gi_ErrCnt[MAX_SOCK] ;
extern uint gi_NumConnect[NBOARDS];   //4 crates * 10 boards
extern uint gi_SecTime, gi_S10Time, gi_MinTime ;
extern uint gi_EvtStart ;
extern uint gi_EvtRead  ;
extern uint gi_EvtBad   ;
extern uint gi_EvtTot   ;
extern int  gi_maxSocks ;    //maximum sockets that will be tried
extern int  gi_runStat ;

extern uint gp_EvtTot   ;
extern int  gp_runStat ;
extern uint gw_EvtTot   ;
extern int  gw_runStat ;




#ifdef __cplusplus
}
#endif

#endif
