#ifndef FACT_DataCalib
#define FACT_DataCalib

#include "DataWriteFits.h"
#include "externals/DrsCalib.h"

class DimDescribedService;

using namespace std;

class DataCalib : public DataWriteFits, public DrsCalibrate
{
    static DrsCalibration fData;

    static std::vector<float> fStats;     /// Storage for mean and rms values

    /// State of the DRS calibration: Positiove numbers mean that
    /// we are in a run, negative mean that it is closed
    static bool fProcessing;

    DimDescribedService &fDim; // DimService through which statistics updates are transmitted

    void WriteFits();

public:
    DataCalib(const std::string &path, uint32_t id, DimDescribedService &dim, MessageImp &imp) : DataWriteFits(path, id, imp), fDim(dim)
    {
    }

    static void Restart();
    static void Update(DimDescribedService &dim);

    bool Open(RUN_HEAD* h);
    bool WriteEvt(EVENT *e);
    bool Close(RUN_TAIL * = 0);

    //static void Apply(int16_t *val, const int16_t *start, uint32_t roi);
    static void Apply(float *vec, int16_t *val, const int16_t *start, uint32_t roi)
    {
        fData.Apply(vec, val, start, roi);
    }

    static bool ReadFits(const string &fname, MessageImp &msg);

    static bool IsValid() { return fData.IsValid(); }
};

#endif
