#include "RemoteControl.h"
#include "Main.h"

using namespace std;

// ========================================================================


/*
 Extract usage clause(s) [if any] for SYNOPSIS.
 Translators: "Usage" and "or" here are patterns (regular expressions) which
 are used to match the usage synopsis in program output.  An example from cp
 (GNU coreutils) which contains both strings:
  Usage: cp [OPTION]... [-T] SOURCE DEST
    or:  cp [OPTION]... SOURCE... DIRECTORY
    or:  cp [OPTION]... -t DIRECTORY SOURCE...
 */
void PrintUsage()
{
    cout << "\n"
        "The console connects to all available Dim Servers and allows to "
        "easily access all of their commands.\n"
        "\n"
        "Usage: dimctrl [-c type] [OPTIONS]\n"
        "  or:  dimctrl [OPTIONS]\n\n";
    cout << endl;
}

void PrintHelp()
{
    Main::PrintUsage();
}

// A simple dummy state machine
class DimCtrl : public MainImp, public MessageImp
{
    bool fStop;

public:
    DimCtrl(ostream &out=cout) : MessageImp(out), fStop(false)
    {
    }

    int EvalOptions(Configuration &) { return -1; }
    void Stop() { fStop = true; }
    int Run(bool) { while (!fStop) usleep(1000); return 0; }
};

int main(int argc, const char *argv[])
{
    Configuration conf(argv[0]);
    conf.SetPrintUsage(PrintUsage);
    Main::SetupConfiguration(conf);

    if (!conf.DoParse(argc, argv, PrintHelp))
        return -1;

    if (!conf.Has("console") || conf.Get<int>("console")==0)
        return Main::execute<RemoteShell, DimCtrl>(conf);
    else
        return Main::execute<RemoteConsole, DimCtrl>(conf);

    return 0;
}
