#include "Time.h"

#include <iostream>

using namespace std;

int main(int, char **)
{
    // Print the local time in the default representation of cout
    cout << endl;
    cout << "Local Time:   " << Time(Time::local) << endl;

    // Print UTC in several different representations
    Time utc; 
    cout << "Universal CT: " << utc << endl;
    cout << "User defined: " << Time::fmt("%Y=%m=%d %H=%M=%S.%f") << utc << endl;
    cout << "SQL-format:   " << Time::sql << utc << endl;
    cout << "ISO-format:   " << Time::iso << utc << endl;
    cout << "Default:      " << Time::reset << utc << endl;
    cout << endl;

    // Copy the UTC into a stringstream and show it on the screen
    stringstream str;
    str << "stringstream: " << Time::sql << utc;
    cout << str.str() << endl;
    cout << endl;

    // Calculate the corresponsing MJD and shoud MJD and corresponding UTC
    const double mjd1 = utc.Mjd();
    cout << "Mjd:   " << Time::sql << utc << " (" << mjd1 << ")" << endl;

    // Set utc to the previously calculated MJD
    utc.Mjd(mjd1);

    // Re-calcualte MJD from this
    const double mjd2 = utc.Mjd();

    // Show the newly calculated MJD and time and the difference between both
    cout << "Mjd:   " << Time::sql << utc << " (" << mjd2 << ")" << endl;
    cout << "Diff:  " << mjd1 - mjd2 << endl;
    cout << endl;

    // Instantiate a Time object with an artificial time
    const Time bd(1974, 9, 9, 21, 59, 42, 123456);

    // Show it in two different representations
    cout << "Loc default:  " << Time::def << bd << endl;
    cout << "Standard:     " << Time::std << bd << endl;
    cout << endl;

    // Clear the stringstream contents
    str.str("");

    // Stream the time in its sql representation into the stringstream
    str << Time::sql << bd;

    // Stream a time from the stringstream considering an sql representation
    // into a Time object
    Time tm;
    str >> Time::sql >> tm;

    // Output stream and interpreted time
    cout << "Stream: " << str.str() << endl; 
    cout << "Time:   " << Time::sql << tm << endl;
    cout << endl;

    // Print the individual elements of the date and the time
    cout << "Elements: ";
    cout << tm.Y() << " " << tm.M() << " " << tm.D() << " " ;
    cout << tm.h() << " " << tm.m() << " " << tm.s() << " " ;
    cout << tm.us() << endl;
    cout << endl;

    return 0;
}

// **************************************************************************
/** @example time.cc

Example for the usage of the class Time

**/
// **************************************************************************
