// **************************************************************************
/** @class EventDim

@brief Concerete implementation of an EventImp as a DimCommand

This is the implementation of an event which can be posted to a state
machine via the DIM network.

@todo
- Add reference to DIM docu
- improve docu

*/
// **************************************************************************
#ifndef FACT_EventDim
#define FACT_EventDim

#include "EventImp.h"

#include "dis.hxx" // DimCommand

class EventDim : public EventImp, public DimCommand
{
public:
    EventDim(int target, const std::string &name, const std::string &format, DimCommandHandler *handler)
        : EventImp(target), DimCommand(name.c_str(), format.c_str(), handler)
    {
        // Initialize these values from DimCommand, because DimCommand
        // does not yet do it.
        itsData   = 0;
        itsSize   = 0;

        secs      = 0;
        millisecs = 0;
    }

    std::string GetName() const   { return const_cast<EventDim*>(this)->getName(); }
    std::string GetFormat() const { return const_cast<EventDim*>(this)->getFormat(); }

    const void *GetData() const   { return const_cast<EventDim*>(this)->getData(); }
    int         GetSize() const   { return const_cast<EventDim*>(this)->getSize(); }

    Time GetTime() const
    {
        return Time(const_cast<EventDim*>(this)->getTimestamp(),
                    const_cast<EventDim*>(this)->getTimestampMillisecs());
    }
};

#endif
