#ifndef FACT_MessageDim
#define FACT_MessageDim

#include "MessageImp.h"



#include <dis.hxx> // DimService

class MessageDimTX : public DimService, public MessageImp
{
public:
    MessageDimTX(const std::string &name, std::ostream &out=std::cout);
    ~MessageDimTX();

    int Write(const Time &t, const char *txt, int qos=kInfo);
};



#include <dic.hxx> // DimStampedInfo

class MessageDimRX : public DimInfoHandler
{
protected:
    MessageImp &fMsg;

private:
    DimStampedInfo fDimMessage;

    int fMinLogLevel;

protected:
    void infoHandler();

public:
    MessageDimRX(const std::string &name, MessageImp &imp);

    void SetMinLogLevel(int min=0) { fMinLogLevel=min; }
};

#endif
